/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.data.httpjson;

import com.atlassian.crowd.plugin.adminchrome.data.ComponentDao;
import com.atlassian.crowd.plugin.adminchrome.data.ComponentRetrievalException;
import com.atlassian.crowd.plugin.adminchrome.data.httpjson.HttpJsonComponentEntry;
import com.atlassian.crowd.plugin.adminchrome.data.httpjson.registryurl.ComponentRegistryUrlManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class HttpJsonComponentDao
implements ComponentDao<HttpJsonComponentEntry> {
    private static final TypeReference<Set<HttpJsonComponentEntry>> RESPONSE_TYPE = new TypeReference<Set<HttpJsonComponentEntry>>(){};
    private final ComponentRegistryUrlManager componentRegistryUrlManager;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public HttpJsonComponentDao(ComponentRegistryUrlManager componentRegistryUrlManager) {
        this(componentRegistryUrlManager, CachingHttpClientBuilder.create().useSystemProperties().build());
    }

    @VisibleForTesting
    HttpJsonComponentDao(ComponentRegistryUrlManager componentRegistryUrlManager, CloseableHttpClient httpClient) {
        this.componentRegistryUrlManager = componentRegistryUrlManager;
        this.httpClient = httpClient;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    @Nonnull
    public Set<HttpJsonComponentEntry> getAllComponents() throws ComponentRetrievalException {
        Set set;
        String url = this.componentRegistryUrlManager.resolveEffectiveComponentRegistryUrl();
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            InputStream inputStream = response.getEntity().getContent();
            set = (Set)this.objectMapper.readValue(inputStream, RESPONSE_TYPE);
        }
        catch (Exception e) {
            try {
                String exceptionMessage = String.format("A problem occurred when trying to retrieve the registered components from the configured url: '%s'", url);
                throw new ComponentRetrievalException(exceptionMessage, e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        return set;
    }

    @Override
    @Nullable
    public HttpJsonComponentEntry getComponent(final @Nonnull String componentName) throws ComponentRetrievalException {
        Preconditions.checkNotNull((Object)componentName, (Object)"componentName must not be null");
        return (HttpJsonComponentEntry)Iterables.find(this.getAllComponents(), (Predicate)new Predicate<HttpJsonComponentEntry>(){

            public boolean apply(HttpJsonComponentEntry component) {
                return component.getName().equals(componentName);
            }
        }, null);
    }
}

