/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.embedded.api.Attributes;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class AttributesMatcher<E extends Attributes>
extends TypeSafeMatcher<Attributes> {
    @Nullable
    private final Matcher<Map<? extends String, ? extends Set<String>>> attributeMapMatcher;

    private AttributesMatcher(Matcher<Map<? extends String, ? extends Set<String>>> attributeMapMatcher) {
        this.attributeMapMatcher = attributeMapMatcher;
    }

    public static <T extends Attributes> AttributesMatcher<T> entityWithAttributes() {
        return new AttributesMatcher(null);
    }

    public static <T extends Attributes> AttributesMatcher<T> entityWithAttributes(Class<T> type) {
        return AttributesMatcher.entityWithAttributes();
    }

    public AttributesMatcher<E> withNoAttributes() {
        return new AttributesMatcher<E>((Matcher<Map<? extends String, ? extends Set<String>>>)Matchers.equalTo(Collections.emptyMap()));
    }

    public AttributesMatcher<E> hasEntry(Matcher<? super String> keyMatcher, Matcher<? super Set<String>> valueMatcher) {
        return new AttributesMatcher<E>((Matcher<Map<? extends String, ? extends Set<String>>>)Matchers.hasEntry(keyMatcher, valueMatcher));
    }

    public AttributesMatcher<E> hasEntry(String key, String singleValue) {
        ImmutableSet expectedValue = ImmutableSet.of((Object)singleValue);
        return new AttributesMatcher<E>((Matcher<Map<? extends String, ? extends Set<String>>>)Matchers.hasEntry((Object)key, (Object)expectedValue));
    }

    protected boolean matchesSafely(Attributes item) {
        if (this.attributeMapMatcher == null) {
            return true;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (String key : item.getKeys()) {
            Set values = item.getValues(key);
            if (values != null) {
                mapBuilder.put((Object)key, (Object)ImmutableSet.copyOf((Collection)values));
                continue;
            }
            throw new ConcurrentModificationException("entity attributes have changed");
        }
        return this.attributeMapMatcher.matches((Object)mapBuilder.build());
    }

    public void describeTo(Description description) {
        description.appendText("Entity with attributes");
        if (this.attributeMapMatcher != null) {
            description.appendText(" that match ").appendDescriptionOf(this.attributeMapMatcher);
        }
    }
}

