package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.directory.DirectoryCacheChangeOperations.GroupsToAddUpdateReplace;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;

import javax.annotation.Nullable;
import java.util.Date;

/**
 * A handler for deciding what action to perform on a group fetched from a remote directory during the synchronisation
 * process
 */
public interface GroupActionStrategy {

    /**
     * @param groupMatchedByName       the group matched by name from the internal directory or null if the group isn't present yet
     * @param groupMatchedByExternalId the group matched by external id from the internal directory or null if there were no matches,
     *                                 only applicable for directories supporting special handling for groups with external ids
     * @param remoteGroup              the group from the remote directory
     * @param syncStartDate            the date at which the synchronisation was started, used to check for local modifications after
     *                                 sync start
     * @param directoryId              the id of the remote directory
     * @return an object containing collections related to different types of handling new groups, one of which may
     * contain the remote group if it should be handled
     * @throws OperationFailedException if the group can't be correctly handled
     */
    GroupsToAddUpdateReplace decide(
            @Nullable InternalDirectoryGroup groupMatchedByName,
            @Nullable InternalDirectoryGroup groupMatchedByExternalId,
            Group remoteGroup,
            Date syncStartDate,
            long directoryId) throws OperationFailedException;
}
