/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask622ExternalId
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask622ExternalId.class);
    private final DirectoryDao directoryDao;
    private final LDAPPropertiesHelper ldapPropertiesHelper;
    private final Collection<String> errors = new ArrayList<String>();
    private static final EntityQuery<Directory> LDAP_CONNECTORS_AND_DELEGATING_DIRECTORIES_QUERY = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CONNECTOR), Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.DELEGATING)})).returningAtMost(-1);

    public UpgradeTask622ExternalId(DirectoryDao directoryDao, LDAPPropertiesHelper ldapPropertiesHelper) {
        this.directoryDao = directoryDao;
        this.ldapPropertiesHelper = ldapPropertiesHelper;
    }

    @Override
    public String getBuildNumber() {
        return "622";
    }

    @Override
    public String getShortDescription() {
        return "Upgrades directories configuration with the User Unique Id attribute";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.directoryDao.search(LDAP_CONNECTORS_AND_DELEGATING_DIRECTORIES_QUERY)) {
            if (!StringUtils.isBlank((CharSequence)directory.getValue("ldap.external.id"))) continue;
            log.debug("Upgrading directory {}", (Object)directory);
            this.upgradeDirectory(directory);
        }
    }

    private void upgradeDirectory(Directory directory) {
        String defaultValue;
        Properties properties = this.getPropertiesForDirectory(UpgradeTask622ExternalId.getClassNameForDirectory(directory));
        if (properties != null && properties.containsKey("ldap.external.id") && StringUtils.isNotBlank((CharSequence)(defaultValue = properties.getProperty("ldap.external.id")))) {
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            directoryToUpdate.setAttribute("ldap.external.id", defaultValue);
            try {
                this.directoryDao.update((Directory)directoryToUpdate);
            }
            catch (DirectoryNotFoundException e) {
                String errorMessage = "Could not update directory " + directory;
                log.error(errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
        }
    }

    @Nullable
    private Properties getPropertiesForDirectory(String ldapClass) {
        return ldapClass != null ? (Properties)this.ldapPropertiesHelper.getConfigurationDetails().get(ldapClass) : null;
    }

    @Nullable
    private static String getClassNameForDirectory(Directory directory) {
        switch (directory.getType()) {
            case CONNECTOR: {
                return directory.getImplementationClass();
            }
            case DELEGATING: {
                return directory.getValue("crowd.delegated.directory.type");
            }
        }
        return null;
    }

    @Override
    public Collection<String> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }
}

