/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask542;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask622
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask542.class);
    private DirectoryDao directoryDao;
    private final Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "622";
    }

    @Override
    public String getShortDescription() {
        return "Upgrading cached LDAP directories to include the attribute localUserStatusEnabled set to true.";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.findLDAPDirectories()) {
            if (!Boolean.valueOf(directory.getValue("com.atlassian.crowd.directory.sync.cache.enabled")).booleanValue() || directory.getValue("localUserStatusEnabled") != null || !directory.getAllowedOperations().contains(OperationType.UPDATE_USER)) continue;
            log.debug("Upgrading directory {}", (Object)directory);
            this.updateDirectory(directory);
        }
    }

    private void updateDirectory(Directory directory) {
        DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
        directoryToUpdate.setAttribute("localUserStatusEnabled", Boolean.TRUE.toString());
        try {
            this.directoryDao.update((Directory)directoryToUpdate);
        }
        catch (DirectoryNotFoundException e) {
            String errorMessage = "Could not update directory " + directory;
            log.error(errorMessage, (Throwable)e);
            this.errors.add(errorMessage + ", error is " + e.getMessage());
        }
    }

    @Override
    public Collection<String> getErrors() {
        return Collections.unmodifiableCollection(this.errors);
    }

    private Iterable<Directory> findLDAPDirectories() {
        return this.directoryDao.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CONNECTOR)).returningAtMost(-1));
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

