/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.hibernate.extras.ResetableHiLoGeneratorHelper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask003
implements UpgradeTask {
    private static final String BUILD_NUMBER = "3";
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask003.class);
    private List<String> errors = new ArrayList<String>();
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;
    private CrowdBootstrapManager bootstrapManager;

    @Override
    public String getBuildNumber() {
        return BUILD_NUMBER;
    }

    @Override
    public String getShortDescription() {
        return "Setting the Hi-Lo value in the database if it has not already been set";
    }

    @Override
    public void doUpgrade() throws Exception {
        try {
            long result = this.resetableHiLoGeneratorHelper.getHiValue();
            if (result <= 1L && this.bootstrapManager.isSetupComplete()) {
                this.resetableHiLoGeneratorHelper.setNextHiValue(this.errors);
            }
        }
        catch (SQLException e) {
            log.error("You cannot start Crowd, since there is an issue with the hibernate_unique_key", (Throwable)e);
            this.errors.add("You cannot start Crowd, since there is an issue with the hibernate_unique_key, please see the log for more details");
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setResetableHiLoGeneratorHelper(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        this.resetableHiLoGeneratorHelper = resetableHiLoGeneratorHelper;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

