/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.trusted;

import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.trusted.InternalCurrentApplication;
import com.atlassian.crowd.trusted.KeyUtils;
import com.atlassian.crowd.trusted.TrustedApplicationStore;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PropertyBasedTrustedApplicationStore
implements TrustedApplicationStore {
    private static final String TRUSTED_APPS_PREFIX = "trustedapps.";
    private static final String TRUSTED_APPS_KEYS = "trustedapps.keys";
    private static final String PUBLIC_KEY_KEY = "public.key";
    private static final String TIMEOUT_KEY = "timeout";
    private static final String URLS_KEY = "urls";
    private static final String IPS_KEY = "ips";
    private static final String CURRENT_APP_PUBLIC_KEY = "trustedapps.currentapp.public.key";
    private static final String CURRENT_APP_PRIVATE_KEY = "trustedapps.currentapp.private.key";
    private static final String CURRENT_APP_UID = "trustedapps.currentapp.uid";
    private final EncryptionProvider encryptionProvider;
    private final PropertyManager propertyManager;
    private final ReadWriteLock settingsLock = new ReentrantReadWriteLock();
    private static final Function<String, String> ENCODER = new Function<String, String>(){

        public String apply(String value) {
            return value.replace("\\", "\\\\").replace("\n", "\\n");
        }
    };
    private static final Function<String, String> DECODER = new Function<String, String>(){

        public String apply(String value) {
            return value.replace("\\n", "\n").replace("\\\\", "\\");
        }
    };
    private final Function<String, TrustedApplication> idToTrustedApplication = new Function<String, TrustedApplication>(){

        public TrustedApplication apply(String id) {
            return PropertyBasedTrustedApplicationStore.this.getTrustedApplication(id);
        }
    };

    public PropertyBasedTrustedApplicationStore(EncryptionProvider encryptionProvider, PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
        this.encryptionProvider = encryptionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<TrustedApplication> getTrustedApplications() {
        this.settingsLock.readLock().lock();
        try {
            Iterable iterable = Iterables.filter((Iterable)Iterables.transform(this.trustedAppsIds(), this.idToTrustedApplication), (Predicate)Predicates.notNull());
            return iterable;
        }
        finally {
            this.settingsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteApplication(String id) {
        this.settingsLock.writeLock().lock();
        try {
            ArrayList ids = Lists.newArrayList(this.trustedAppsIds());
            if (ids.contains(id)) {
                ids.remove(id);
                this.storeIds(ids);
                PropertyAccessor accessor = this.accessor(id);
                accessor.remove(PUBLIC_KEY_KEY);
                accessor.remove(TIMEOUT_KEY);
                accessor.remove(URLS_KEY);
                accessor.remove(IPS_KEY);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.settingsLock.writeLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTrustedApplication(TrustedApplication app) {
        this.settingsLock.writeLock().lock();
        try {
            ArrayList ids = Lists.newArrayList(this.trustedAppsIds());
            String id = app.getID();
            if (!ids.contains(id)) {
                ids.add(id);
                this.storeIds(ids);
            }
            PropertyAccessor accessor = this.accessor(id);
            RequestConditions conditions = app.getRequestConditions();
            accessor.set(PUBLIC_KEY_KEY, KeyUtils.encode(app.getPublicKey()));
            accessor.set(TIMEOUT_KEY, Long.toString(conditions.getCertificateTimeout()));
            accessor.set(URLS_KEY, PropertyBasedTrustedApplicationStore.iterableToCommaSeparatedString(conditions.getURLPatterns()));
            accessor.set(IPS_KEY, PropertyBasedTrustedApplicationStore.iterableToCommaSeparatedString(conditions.getIPPatterns()));
        }
        finally {
            this.settingsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrustedApplication getTrustedApplication(String id) {
        this.settingsLock.readLock().lock();
        try {
            PropertyAccessor accessor = this.accessor(id);
            String publicKey = accessor.get(PUBLIC_KEY_KEY, null);
            if (publicKey == null) {
                TrustedApplication trustedApplication = null;
                return trustedApplication;
            }
            long timeout = Long.parseLong(accessor.get(TIMEOUT_KEY, "0"));
            String[] urls = (String[])Iterables.toArray(PropertyBasedTrustedApplicationStore.decodeCommaSeparatedString(accessor.get(URLS_KEY, null)), String.class);
            String[] ips = (String[])Iterables.toArray(PropertyBasedTrustedApplicationStore.decodeCommaSeparatedString(accessor.get(IPS_KEY, null)), String.class);
            RequestConditions requestConditions = RequestConditions.builder().setCertificateTimeout(timeout).addURLPattern(urls).addIPPattern(ips).build();
            DefaultTrustedApplication defaultTrustedApplication = new DefaultTrustedApplication(this.encryptionProvider, KeyUtils.decodePublicKey(this.encryptionProvider, publicKey), id, requestConditions);
            return defaultTrustedApplication;
        }
        finally {
            this.settingsLock.readLock().unlock();
        }
    }

    @Override
    public synchronized InternalCurrentApplication getCurrentApplication() {
        String uid = this.propertyManager.getString(CURRENT_APP_UID, null);
        String privateKey = this.propertyManager.getString(CURRENT_APP_PRIVATE_KEY, null);
        String publicKey = this.propertyManager.getString(CURRENT_APP_PUBLIC_KEY, null);
        if (uid == null) {
            return null;
        }
        return new InternalCurrentApplication(uid, privateKey, publicKey);
    }

    @Override
    public synchronized void storeCurrentApplication(InternalCurrentApplication currentApplication) {
        this.propertyManager.setProperty(CURRENT_APP_UID, currentApplication.getUid());
        this.propertyManager.setProperty(CURRENT_APP_PRIVATE_KEY, currentApplication.getPrivateKey());
        this.propertyManager.setProperty(CURRENT_APP_PUBLIC_KEY, currentApplication.getPublicKey());
    }

    private Iterable<String> trustedAppsIds() {
        String keys = this.propertyManager.getString(TRUSTED_APPS_KEYS, "");
        return PropertyBasedTrustedApplicationStore.decodeCommaSeparatedString(keys);
    }

    @VisibleForTesting
    static Iterable<String> decodeCommaSeparatedString(String str) {
        if (str == null) {
            return ImmutableList.of();
        }
        return Iterables.transform((Iterable)Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)str), DECODER);
    }

    @VisibleForTesting
    static String iterableToCommaSeparatedString(Iterable<String> iterable) {
        return Joiner.on((char)'\n').join(Iterables.transform(iterable, ENCODER));
    }

    private void storeIds(Iterable<String> ids) {
        if (Iterables.isEmpty(ids)) {
            this.propertyManager.removeProperty(TRUSTED_APPS_KEYS);
        } else {
            this.propertyManager.setProperty(TRUSTED_APPS_KEYS, PropertyBasedTrustedApplicationStore.iterableToCommaSeparatedString(ids));
        }
    }

    private PropertyAccessor accessor(String id) {
        return new PropertyAccessor(id);
    }

    private class PropertyAccessor {
        private final String id;

        private PropertyAccessor(String id) {
            this.id = id;
        }

        public String get(String property, String defaultValue) {
            return PropertyBasedTrustedApplicationStore.this.propertyManager.getString(this.propertyKey(property), defaultValue);
        }

        public void set(String property, String value) {
            PropertyBasedTrustedApplicationStore.this.propertyManager.setProperty(this.propertyKey(property), value);
        }

        public void remove(String property) {
            PropertyBasedTrustedApplicationStore.this.propertyManager.removeProperty(this.propertyKey(property));
        }

        private String propertyKey(String property) {
            return PropertyBasedTrustedApplicationStore.TRUSTED_APPS_PREFIX + this.id + "." + property;
        }
    }
}

