/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.trusted;

import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.commons.codec.binary.Base64;

public class KeyUtils {
    public static String encode(Key key) {
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public static PrivateKey decodePrivateKey(EncryptionProvider encryptionProvider, String keyStr) {
        byte[] data = KeyUtils.decodeKey(keyStr);
        try {
            return encryptionProvider.toPrivateKey(data);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PublicKey decodePublicKey(EncryptionProvider encryptionProvider, String keyStr) {
        byte[] data = KeyUtils.decodeKey(keyStr);
        try {
            return encryptionProvider.toPublicKey(data);
        }
        catch (NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] decodeKey(String keyStr) {
        return Base64.decodeBase64((String)keyStr);
    }
}

