/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.web;

import com.atlassian.crowd.plugin.web.TemplateRenderer;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CrowdWebFragmentHelper
implements WebFragmentHelper,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private I18nHelper i18nHelper;
    private TemplateRenderer templateRenderer;

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        return (Condition)this.loadComponent(className, plugin);
    }

    private Object loadComponent(String className, Plugin plugin) throws ConditionLoadingException {
        Class clz;
        try {
            clz = plugin.loadClass(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new ConditionLoadingException((Throwable)e);
        }
        try {
            if (plugin instanceof ContainerManagedPlugin) {
                return ((ContainerManagedPlugin)plugin).getContainerAccessor().createBean(clz);
            }
            return this.applicationContext.getAutowireCapableBeanFactory().createBean(clz, 1, false);
        }
        catch (Exception e) {
            throw new ConditionLoadingException((Throwable)e);
        }
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        return (ContextProvider)this.loadComponent(className, plugin);
    }

    public String getI18nValue(String key, List arguments, Map context) {
        String labelValue = LocalizedTextUtil.findDefaultText((String)key, (Locale)ActionContext.getContext().getLocale());
        if (!StringUtils.isEmpty((CharSequence)labelValue)) {
            return key;
        }
        labelValue = this.i18nHelper.getText(key, (Object)arguments);
        return labelValue;
    }

    public String renderVelocityFragment(String fragment, Map context) {
        if (!this.needToRender(fragment)) {
            return fragment;
        }
        String parsedResult = null;
        parsedResult = this.templateRenderer.renderText(fragment, context);
        return parsedResult;
    }

    private boolean needToRender(String fragment) {
        return TextUtils.stringSet((String)fragment) && (fragment.indexOf("$") >= 0 || fragment.indexOf("#") >= 0);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }
}

