/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.descriptors.webwork;

import com.atlassian.crowd.plugin.descriptors.webwork.PluginAwareActionConfig;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.RuntimeConfiguration;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.impl.DefaultConfiguration;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PluginAwareConfiguration
extends DefaultConfiguration {
    protected ActionConfig createActionConfig(ActionConfig baseConfig, Map params, Map results, List interceptors, List externalRefs, List exceptionMappings, String packageName) {
        if (baseConfig instanceof PluginAwareActionConfig) {
            PluginAwareActionConfig actionConfig = new PluginAwareActionConfig(baseConfig.getMethodName(), baseConfig.getClassName(), params, results, interceptors, externalRefs, exceptionMappings, packageName);
            actionConfig.setPlugin(((PluginAwareActionConfig)baseConfig).getPlugin());
            return actionConfig;
        }
        return new ActionConfig(baseConfig.getMethodName(), baseConfig.getClassName(), params, results, interceptors, externalRefs, exceptionMappings, packageName);
    }

    private ActionConfig buildFullActionConfig(PackageConfig packageContext, ActionConfig baseConfig) throws ConfigurationException {
        String defaultInterceptorRefName;
        TreeMap params = new TreeMap(baseConfig.getParams());
        TreeMap results = new TreeMap();
        if (baseConfig.getPackageName().equals(packageContext.getName())) {
            results.putAll(packageContext.getAllGlobalResults());
            results.putAll(baseConfig.getResults());
        } else {
            PackageConfig baseConfigPackageConfig = (PackageConfig)this.getPackageConfigs().get(baseConfig.getPackageName());
            if (baseConfigPackageConfig != null) {
                results.putAll(baseConfigPackageConfig.getAllGlobalResults());
            }
            results.putAll(baseConfig.getResults());
        }
        this.setDefaultResults(results, packageContext);
        ArrayList interceptors = new ArrayList(baseConfig.getInterceptors());
        if (interceptors.size() <= 0 && (defaultInterceptorRefName = packageContext.getFullDefaultInterceptorRef()) != null) {
            interceptors.addAll(InterceptorBuilder.constructInterceptorReference((PackageConfig)packageContext, (String)defaultInterceptorRefName, new LinkedHashMap()));
        }
        List externalRefs = baseConfig.getExternalRefs();
        List exceptionMappings = baseConfig.getExceptionMappings();
        exceptionMappings.addAll(packageContext.getAllExceptionMappingConfigs());
        ActionConfig config = this.createActionConfig(baseConfig, params, results, interceptors, externalRefs, exceptionMappings, packageContext.getName());
        return config;
    }

    protected synchronized RuntimeConfiguration buildRuntimeConfiguration() throws ConfigurationException {
        LinkedHashMap namespaceActionConfigs = new LinkedHashMap();
        LinkedHashMap<String, String> namespaceConfigs = new LinkedHashMap<String, String>();
        for (PackageConfig packageContext : this.getPackageConfigs().values()) {
            if (packageContext.isAbstract()) continue;
            String namespace = packageContext.getNamespace();
            LinkedHashMap<String, ActionConfig> configs = (LinkedHashMap<String, ActionConfig>)namespaceActionConfigs.get(namespace);
            if (configs == null) {
                configs = new LinkedHashMap<String, ActionConfig>();
            }
            Map actionConfigs = packageContext.getAllActionConfigs();
            for (String actionName : actionConfigs.keySet()) {
                ActionConfig baseConfig = (ActionConfig)actionConfigs.get(actionName);
                configs.put(actionName, this.buildFullActionConfig(packageContext, baseConfig));
            }
            namespaceActionConfigs.put(namespace, configs);
            if (packageContext.getFullDefaultActionRef() == null) continue;
            namespaceConfigs.put(namespace, packageContext.getFullDefaultActionRef());
        }
        return new RuntimeConfigurationImpl(namespaceActionConfigs, namespaceConfigs);
    }

    private void setDefaultResults(Map results, PackageConfig packageContext) {
        String defaultResult = packageContext.getFullDefaultResultType();
        for (Map.Entry entry : results.entrySet()) {
            if (entry.getValue() != null) continue;
            ResultTypeConfig resultTypeConfig = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(defaultResult);
            entry.setValue(resultTypeConfig.getClazz());
        }
    }

    private class RuntimeConfigurationImpl
    implements RuntimeConfiguration {
        private Map namespaceActionConfigs;
        private Map namespaceConfigs;

        public RuntimeConfigurationImpl(Map namespaceActionConfigs, Map namespaceConfigs) {
            this.namespaceActionConfigs = namespaceActionConfigs;
            this.namespaceConfigs = namespaceConfigs;
        }

        public synchronized ActionConfig getActionConfig(String namespace, String name) {
            String defaultActionRef;
            ActionConfig config = null;
            Map actions = (Map)this.namespaceActionConfigs.get(namespace == null ? "" : namespace);
            if (actions != null && (config = (ActionConfig)actions.get(name)) == null && (defaultActionRef = (String)this.namespaceConfigs.get(namespace == null ? "" : namespace)) != null) {
                config = (ActionConfig)actions.get(defaultActionRef);
            }
            if (config == null && namespace != null && !namespace.trim().equals("") && (actions = (Map)this.namespaceActionConfigs.get("")) != null && (config = (ActionConfig)actions.get(name)) == null && (defaultActionRef = (String)this.namespaceConfigs.get("")) != null) {
                config = (ActionConfig)actions.get(defaultActionRef);
            }
            return config;
        }

        public synchronized Map getActionConfigs() {
            return this.namespaceActionConfigs;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("RuntimeConfiguration - actions are\n");
            for (String namespace : this.namespaceActionConfigs.keySet()) {
                Map actionConfigs = (Map)this.namespaceActionConfigs.get(namespace);
                Iterator iterator2 = actionConfigs.keySet().iterator();
                while (iterator2.hasNext()) {
                    buff.append(namespace + "/" + iterator2.next() + "\n");
                }
            }
            return buff.toString();
        }
    }
}

