/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.metadata.RequiredPluginProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequiredPluginsStartupCheck {
    private static final Logger log = LoggerFactory.getLogger(RequiredPluginsStartupCheck.class);
    private final PluginAccessor accessor;
    private final RequiredPluginProvider pmm;

    public RequiredPluginsStartupCheck(PluginAccessor accessor, RequiredPluginProvider pmm) {
        this.accessor = accessor;
        this.pmm = pmm;
    }

    public List<String> requiredPluginsNotEnabled() {
        ArrayList<String> notEnabled = new ArrayList<String>();
        Collection plugins = this.accessor.getPlugins();
        if (plugins.isEmpty()) {
            log.warn("No plugins present.");
        }
        HashSet<String> seen = new HashSet<String>();
        log.debug("Listing all plugins...");
        for (Plugin p : plugins) {
            log.debug("Plugin: {}", (Object)p);
            if (this.isRequired(p) && p.getPluginState() != PluginState.ENABLED) {
                log.error("Required plugin is disabled: " + p);
                String name = p.getName();
                if (name != null) {
                    notEnabled.add(name);
                } else {
                    notEnabled.add(p.toString());
                }
            }
            seen.add(p.getKey());
        }
        log.debug("...done");
        HashSet expected = new HashSet(this.pmm.getRequiredPluginKeys());
        expected.removeAll(seen);
        for (String s : expected) {
            log.error("Required plugin is missing: " + s);
            notEnabled.add(s);
        }
        return notEnabled;
    }

    boolean isRequired(Plugin p) {
        return this.pmm.getRequiredPluginKeys().contains(p.getKey());
    }
}

