/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;

public class SALPropertyMapper
extends DatabaseMapper
implements DatabaseImporter {
    public SALPropertyMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        List<Property> salProperties = this.importSALPropertiesFromDatabase();
        for (Property salProperty : salProperties) {
            this.addEntityViaSave(salProperty);
        }
        this.logger.info("Successfully migrated " + salProperties.size() + " SAL properties.");
    }

    public List<Property> importSALPropertiesFromDatabase() {
        SALPropertyTableMapper salPropertyTableMapper = new SALPropertyTableMapper();
        List<Object> salProperties = new ArrayList<Property>();
        try {
            salProperties = this.jdbcTemplate.query(this.legacyTableQueries.getSALPropertiesSQL(), (RowMapper)salPropertyTableMapper);
        }
        catch (BadSqlGrammarException e) {
            this.logger.info("No sal properties were found for importing!");
        }
        return salProperties;
    }

    private class SALPropertyTableMapper
    implements RowMapper {
        private SALPropertyTableMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            String key = rs.getString("KEY");
            String propertyName = rs.getString("PROPERTYNAME");
            String propertyValue = rs.getString("STRINGVALUE");
            return new Property("plugin." + key, propertyName, propertyValue);
        }
    }
}

