/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class ApplicationMapper
extends DatabaseMapper
implements DatabaseImporter {
    private final DirectoryDAOHibernate directoryDAO;

    public ApplicationMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
        this.directoryDAO = directoryDAO;
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        List<ApplicationImpl> applications = this.importApplicationsFromDatabase(importData.getOldToNewDirectoryIds());
        for (ApplicationImpl application : applications) {
            this.addEntityViaMerge(application);
        }
        this.logger.info("Successfully migrated " + applications.size() + " applications.");
    }

    protected List<ApplicationImpl> importApplicationsFromDatabase(Map<Long, Long> oldToNewDirectoryIds) {
        ApplicationTableMapper applicationTableMapper = new ApplicationTableMapper();
        List<ApplicationImpl> applications = this.getApplications(applicationTableMapper);
        Map<Application, Long> applicationIdMap = applicationTableMapper.getApplicationIdMap();
        Map<Long, List<Map<String, String>>> allApplicationAttributes = this.getApplicationAttributes();
        Map<Long, List<AppDirMappingDataHolder>> allApplicationDirectoryMappingData = this.getDirectoryMappingData();
        Map<Long, PasswordCredential> allApplicationCredentials = this.getApplicationPasswordCredentials();
        Map<Long, Set<RemoteAddress>> allApplicationAddresses = this.getRemoteAddresses();
        for (ApplicationImpl application : applications) {
            Long oldApplicationId = applicationIdMap.get(application);
            Map<String, String> applicationAttributes = this.attributeListToMap(allApplicationAttributes.get(oldApplicationId));
            application.setAttributes(applicationAttributes);
            application.setType(this.getApplicationType(applicationAttributes));
            ArrayList<DirectoryMapping> directoryMappings = new ArrayList<DirectoryMapping>();
            List<AppDirMappingDataHolder> directoryMappingData = allApplicationDirectoryMappingData.get(oldApplicationId);
            if (directoryMappingData == null) {
                directoryMappingData = new ArrayList<AppDirMappingDataHolder>();
            }
            for (AppDirMappingDataHolder mappingData : directoryMappingData) {
                Long oldDirectoryId = mappingData.getOldDirectoryId();
                Directory directoryReference = (Directory)this.directoryDAO.loadReference(oldToNewDirectoryIds.get(oldDirectoryId).longValue());
                DirectoryMapping directoryMapping = new DirectoryMapping((Application)application, directoryReference, mappingData.isAllowAllToAuthenticate());
                directoryMapping.setAllowedOperations(mappingData.getAllowedOperations());
                Set<String> groupNames = mappingData.getAuthorisedGroupNames();
                for (String groupName : groupNames) {
                    if (!StringUtils.isNotBlank((CharSequence)groupName)) continue;
                    GroupMapping groupMapping = new GroupMapping(directoryMapping, groupName);
                    directoryMapping.getAuthorisedGroups().add(groupMapping);
                }
                directoryMappings.add(directoryMapping);
            }
            application.getDirectoryMappings().addAll(directoryMappings);
            PasswordCredential credential = allApplicationCredentials.get(oldApplicationId);
            if (credential == null) {
                credential = new PasswordCredential("password", true);
            }
            application.setCredential(credential);
            Set<RemoteAddress> remoteAddresses = allApplicationAddresses.get(oldApplicationId);
            if (remoteAddresses == null) {
                remoteAddresses = new HashSet<RemoteAddress>();
            }
            application.setRemoteAddresses(remoteAddresses);
        }
        return applications;
    }

    private List<ApplicationImpl> getApplications(ApplicationTableMapper applicationTableMapper) {
        return this.jdbcTemplate.query(this.legacyTableQueries.getApplicationsSQL(), (RowMapper)applicationTableMapper);
    }

    private Map<Long, List<AppDirMappingDataHolder>> getDirectoryMappingData() {
        DirectoryMappingTableMapper directoryMappingTableMapper = new DirectoryMappingTableMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getDirectoryMappingDataSQL(), (RowCallbackHandler)directoryMappingTableMapper);
        Map<Long, List<AppDirMappingDataHolder>> allApplicationDirectoryMappings = directoryMappingTableMapper.getApplicationDirectoryMappingMap();
        allApplicationDirectoryMappings = this.addAllowedOperations(allApplicationDirectoryMappings);
        allApplicationDirectoryMappings = this.addAssociatedGroups(allApplicationDirectoryMappings);
        return allApplicationDirectoryMappings;
    }

    private Map<Long, Set<RemoteAddress>> getRemoteAddresses() {
        RemoteAddressTableMapper remoteAddressTableMapper = new RemoteAddressTableMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getRemoteAddressesSQL(), (RowCallbackHandler)remoteAddressTableMapper);
        return remoteAddressTableMapper.getApplicationAddresses();
    }

    private Map<Long, PasswordCredential> getApplicationPasswordCredentials() {
        ApplicationCredentialMapper applicationCredentialMapper = new ApplicationCredentialMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getApplicationPasswordCredentialsSQL(), (RowCallbackHandler)applicationCredentialMapper);
        return applicationCredentialMapper.getApplicationCredential();
    }

    private Map<Long, List<Map<String, String>>> getApplicationAttributes() {
        ApplicationAttributeMapper applicationAttributeMapper = new ApplicationAttributeMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getApplicationAttributesSQL(), (RowCallbackHandler)applicationAttributeMapper);
        Map<Long, List<Map<String, String>>> attributes = applicationAttributeMapper.getApplicationAttributes();
        if (attributes == null) {
            attributes = new HashMap<Long, List<Map<String, String>>>();
        }
        return attributes;
    }

    private Map<Long, List<AppDirMappingDataHolder>> addAllowedOperations(Map<Long, List<AppDirMappingDataHolder>> allApplicationDirectoryMappings) {
        AppDirOperationTableMapper appDirOperationTableMapper = new AppDirOperationTableMapper(allApplicationDirectoryMappings);
        this.jdbcTemplate.query(this.legacyTableQueries.getAllowedOperationsSQL(), (RowCallbackHandler)appDirOperationTableMapper);
        Map<Long, List<AppDirMappingDataHolder>> allowedOperations = appDirOperationTableMapper.getApplicationDirectoryMappings();
        if (allowedOperations == null) {
            allowedOperations = new HashMap<Long, List<AppDirMappingDataHolder>>();
        }
        return allowedOperations;
    }

    private Map<Long, List<AppDirMappingDataHolder>> addAssociatedGroups(Map<Long, List<AppDirMappingDataHolder>> allApplicationDirectoryMappings) {
        AppDirGroupTableMapper appDirGroupTableMapper = new AppDirGroupTableMapper(allApplicationDirectoryMappings);
        this.jdbcTemplate.query(this.legacyTableQueries.getAssociatedGroupsSQL(), (RowCallbackHandler)appDirGroupTableMapper);
        Map<Long, List<AppDirMappingDataHolder>> associatedGroups = appDirGroupTableMapper.getApplicationDirectoryMappings();
        if (associatedGroups == null) {
            associatedGroups = new HashMap<Long, List<AppDirMappingDataHolder>>();
        }
        return associatedGroups;
    }

    private ApplicationType getApplicationType(Map<String, String> applicationAttributes) {
        ApplicationType applicationType;
        String type = applicationAttributes.get("applicationType");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            try {
                applicationType = ApplicationType.valueOf((String)type);
            }
            catch (IllegalArgumentException e) {
                applicationType = ApplicationType.GENERIC_APPLICATION;
            }
        } else {
            applicationType = ApplicationType.GENERIC_APPLICATION;
        }
        return applicationType;
    }

    private class AppDirMappingDataHolder {
        private Long oldDirectoryId;
        private boolean allowAllToAuthenticate;
        private Set<String> authorisedGroupNames = new HashSet<String>();
        private Set<OperationType> allowedOperations = new HashSet<OperationType>();

        private AppDirMappingDataHolder(Long oldDirectoryId) {
            this.oldDirectoryId = oldDirectoryId;
        }

        public void setAllowAllToAuthenticate(boolean allowAllToAuthenticate) {
            this.allowAllToAuthenticate = allowAllToAuthenticate;
        }

        public Set<OperationType> getAllowedOperations() {
            return this.allowedOperations;
        }

        public Set<String> getAuthorisedGroupNames() {
            return this.authorisedGroupNames;
        }

        public boolean isAllowAllToAuthenticate() {
            return this.allowAllToAuthenticate;
        }

        public Long getOldDirectoryId() {
            return this.oldDirectoryId;
        }
    }

    private class AppDirOperationTableMapper
    implements RowCallbackHandler {
        private Map<Long, List<AppDirMappingDataHolder>> applicationDirectoryMappings;

        private AppDirOperationTableMapper(Map<Long, List<AppDirMappingDataHolder>> applicationDirectoryMappings) {
            this.applicationDirectoryMappings = applicationDirectoryMappings;
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long applicationId = rs.getLong("APPLICATIONID");
            Long oldDirectoryId = rs.getLong("DIRECTORYID");
            String permissionType = rs.getString("PERMISSION_TYPE");
            OperationType operation = ApplicationMapper.this.getOperationTypeFromLegacyPermissionName(permissionType);
            List<AppDirMappingDataHolder> directoryMappings = this.applicationDirectoryMappings.get(applicationId);
            for (AppDirMappingDataHolder mapping : directoryMappings) {
                if (!mapping.getOldDirectoryId().equals(oldDirectoryId) || operation == null) continue;
                mapping.getAllowedOperations().add(operation);
            }
        }

        public Map<Long, List<AppDirMappingDataHolder>> getApplicationDirectoryMappings() {
            return this.applicationDirectoryMappings;
        }
    }

    private class AppDirGroupTableMapper
    implements RowCallbackHandler {
        private Map<Long, List<AppDirMappingDataHolder>> applicationDirectoryMappings;

        public AppDirGroupTableMapper(Map<Long, List<AppDirMappingDataHolder>> applicationDirectoryMappings) {
            this.applicationDirectoryMappings = applicationDirectoryMappings;
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long applicationId = rs.getLong("APPLICATIONID");
            Long oldDirectoryId = rs.getLong("DIRECTORYID");
            String name = rs.getString("NAME");
            List<AppDirMappingDataHolder> directoryMappings = this.applicationDirectoryMappings.get(applicationId);
            for (AppDirMappingDataHolder mapping : directoryMappings) {
                if (!mapping.getOldDirectoryId().equals(oldDirectoryId) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                mapping.getAuthorisedGroupNames().add(name);
            }
        }

        public Map<Long, List<AppDirMappingDataHolder>> getApplicationDirectoryMappings() {
            return this.applicationDirectoryMappings;
        }
    }

    private class DirectoryMappingTableMapper
    implements RowCallbackHandler {
        private final Map<Long, List<AppDirMappingDataHolder>> applicationDirectoryMappingMap = new HashMap<Long, List<AppDirMappingDataHolder>>();

        private DirectoryMappingTableMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long applicationId = rs.getLong("APPLICATIONID");
            Long oldDirectoryId = rs.getLong("DIRECTORYID");
            boolean allowAllToAuthenticate = rs.getBoolean("ALLOWALLTOAUTHENTICATE");
            AppDirMappingDataHolder appDirMappingDataHolder = new AppDirMappingDataHolder(oldDirectoryId);
            appDirMappingDataHolder.setAllowAllToAuthenticate(allowAllToAuthenticate);
            if (!this.applicationDirectoryMappingMap.containsKey(applicationId)) {
                this.applicationDirectoryMappingMap.put(applicationId, new ArrayList());
            }
            this.applicationDirectoryMappingMap.get(applicationId).add(appDirMappingDataHolder);
        }

        public Map<Long, List<AppDirMappingDataHolder>> getApplicationDirectoryMappingMap() {
            return this.applicationDirectoryMappingMap;
        }
    }

    private class ApplicationAttributeMapper
    implements RowCallbackHandler {
        private final Map<Long, List<Map<String, String>>> applicationAttributes = new HashMap<Long, List<Map<String, String>>>();

        private ApplicationAttributeMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            String attributeName = rs.getString("ATTRIBUTE");
            String attributeValue = rs.getString("VALUE");
            Long applicationId = rs.getLong("APPLICATIONID");
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(attributeName, attributeValue);
            if (!this.applicationAttributes.containsKey(applicationId)) {
                this.applicationAttributes.put(applicationId, new ArrayList());
            }
            this.applicationAttributes.get(applicationId).add(attributes);
        }

        public Map<Long, List<Map<String, String>>> getApplicationAttributes() {
            return this.applicationAttributes;
        }
    }

    private class ApplicationCredentialMapper
    implements RowCallbackHandler {
        private final Map<Long, PasswordCredential> applicationCredential = new HashMap<Long, PasswordCredential>();

        private ApplicationCredentialMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long applicationId = rs.getLong("APPLICATIONID");
            String credential = rs.getString("CREDENTIAL");
            PasswordCredential passwordCredential = StringUtils.isNotBlank((CharSequence)credential) ? new PasswordCredential(credential, true) : new PasswordCredential("password", true);
            this.applicationCredential.put(applicationId, passwordCredential);
        }

        public Map<Long, PasswordCredential> getApplicationCredential() {
            return this.applicationCredential;
        }
    }

    private class RemoteAddressTableMapper
    implements RowCallbackHandler {
        Map<Long, Set<RemoteAddress>> applicationAddresses = new HashMap<Long, Set<RemoteAddress>>();

        private RemoteAddressTableMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long applicationId = rs.getLong("APPLICATIONID");
            String address = rs.getString("ADDRESS");
            if (!this.applicationAddresses.containsKey(applicationId)) {
                this.applicationAddresses.put(applicationId, new HashSet());
            }
            this.applicationAddresses.get(applicationId).add(new RemoteAddress(address));
        }

        public Map<Long, Set<RemoteAddress>> getApplicationAddresses() {
            return this.applicationAddresses;
        }
    }

    private class ApplicationTableMapper
    implements RowMapper {
        private final Map<Application, Long> applicationIdMap = new HashMap<Application, Long>();

        private ApplicationTableMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long oldApplicationId = rs.getLong("ID");
            String name = rs.getString("NAME");
            Date createDate = ApplicationMapper.this.getDateFromDatabase(rs.getString("CONCEPTION"));
            Date updatedDate = ApplicationMapper.this.getDateFromDatabase(rs.getString("LASTMODIFIED"));
            boolean active = rs.getBoolean("ACTIVE");
            String description = rs.getString("DESCRIPTION");
            InternalEntityTemplate template = ApplicationMapper.this.createInternalEntityTemplate(oldApplicationId, name, createDate, updatedDate, active);
            template.setId(null);
            ApplicationImpl application = new ApplicationImpl(template);
            application.setDescription(description);
            this.applicationIdMap.put((Application)application, oldApplicationId);
            return application;
        }

        public Map<Application, Long> getApplicationIdMap() {
            return this.applicationIdMap;
        }
    }
}

