/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.dao.property.PropertyDAOHibernate;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.GenericLegacyImporter;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.LegacyImporter;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.Iterator;
import org.dom4j.Element;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SALPropertyMapper
extends GenericLegacyImporter
implements LegacyImporter {
    private final Logger logger = LoggerFactory.getLogger(SALPropertyMapper.class);
    private final PropertyDAOHibernate propertyDAO;
    protected static final String SALPROPERTY_XML_ROOT = "salProperties";
    protected static final String SALPROPERTY_XML_NODE = "salProperty";
    protected static final String SALPROPERTY_XML_KEY = "key";
    protected static final String SALPROPERTY_XML_PROPERTY_NAME = "propertyName";
    protected static final String SALPROPERTY_XML_STRING_VALUE = "propertyValue";

    public SALPropertyMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, PropertyDAOHibernate propertyDAO) {
        super(sessionFactory, batchProcessor);
        this.propertyDAO = propertyDAO;
    }

    @Override
    public void importXml(Element root, LegacyImportDataHolder importData) throws ImportException {
        Element salPropertiesElement = (Element)root.selectSingleNode("/crowd/ salProperties");
        if (salPropertiesElement == null) {
            this.logger.info("No sal properties were found for importing!");
        } else {
            Iterator salProperties = salPropertiesElement.elementIterator();
            while (salProperties.hasNext()) {
                Element salPropertyElement = (Element)salProperties.next();
                String key = salPropertyElement.element(SALPROPERTY_XML_KEY).getText();
                String propertyName = salPropertyElement.element(SALPROPERTY_XML_PROPERTY_NAME).getText();
                String stringValue = salPropertyElement.element(SALPROPERTY_XML_STRING_VALUE).getText();
                this.addEntityViaSave(new Property("plugin." + key, propertyName, stringValue));
            }
        }
    }
}

