/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.XmlMapper;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.crowd.util.PropertyUtils;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class CrowdPropertiesMapper
extends XmlMapper
implements Mapper {
    protected static final String PROPERTIES_XML_ROOT = "crowdproperties";
    protected static final String PROPERTY_XML_NODE = "property";
    protected static final String PROPERTY_XML_NAME = "name";
    protected static final String PROPERTY_XML_VALUE = "value";
    protected final ClientProperties clientProperties;
    private final ResourceLocator resourceLocator;
    private final PropertyUtils propertyUtils;

    public CrowdPropertiesMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, ClientProperties clientProperties, ResourceLocator resourceLocator, PropertyUtils propertyUtils) {
        super(sessionFactory, batchProcessor);
        this.clientProperties = clientProperties;
        this.resourceLocator = resourceLocator;
        this.propertyUtils = propertyUtils;
    }

    @Override
    public Element exportXml(Map options) throws ExportException {
        Element crowdPropertiesRoot = DocumentHelper.createElement((String)PROPERTIES_XML_ROOT);
        Properties properties = this.resourceLocator.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (String string : properties.keySet()) {
                String propertyValue = properties.getProperty(string);
                Element propertyElement = crowdPropertiesRoot.addElement(PROPERTY_XML_NODE);
                propertyElement.addElement(PROPERTY_XML_NAME).addText(string);
                propertyElement.addElement(PROPERTY_XML_VALUE).addText(propertyValue);
            }
        } else {
            this.logger.error("Failed to find any properties in crowd.properties!");
        }
        return crowdPropertiesRoot;
    }

    @Override
    public void importXml(Element root) throws ImportException {
        Element propertiesElement = (Element)root.selectSingleNode("/crowd/ crowdproperties");
        if (propertiesElement == null) {
            this.logger.info("No properties were found for importing.");
            return;
        }
        Iterator properties = propertiesElement.elementIterator();
        while (properties.hasNext()) {
            Element propertyElemet = (Element)properties.next();
            String name = propertyElemet.element(PROPERTY_XML_NAME).getText();
            String value = propertyElemet.element(PROPERTY_XML_VALUE).getText();
            this.propertyUtils.updateProperty(this.resourceLocator.getResourceLocation(), name, value);
        }
        this.clientProperties.updateProperties(this.resourceLocator.getProperties());
    }
}

