/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.upgrade;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.dao.token.ResetPasswordTokenDaoMemory;
import com.atlassian.crowd.dao.token.TokenDAOMemory;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.manager.upgrade.UpgradeManager;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.CacheManager;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class UpgradeManagerImpl
implements UpgradeManager {
    private final Logger logger = LoggerFactory.getLogger(UpgradeManagerImpl.class);
    private CrowdBootstrapManager bootstrapManager;
    private List<UpgradeTask> upgradeTasks = new ArrayList<UpgradeTask>();
    private PropertyManager propertyManager;
    private SessionFactory sessionFactory;
    private CacheManager cacheManager;
    private static final Set<String> RETAINED_CACHES_ON_UPGRADE = ImmutableSet.of((Object)TokenDAOMemory.IDENTIFIER_HASH_CACHE, (Object)TokenDAOMemory.RANDOM_HASH_CACHE, (Object)ResetPasswordTokenDaoMemory.CACHE_NAME);

    protected int getApplicationBuildNumber() {
        return Integer.parseInt("624");
    }

    @Override
    public int getDataBuildNumber() {
        int buildNumber;
        try {
            buildNumber = this.propertyManager.getBuildNumber();
        }
        catch (PropertyManagerException e) {
            buildNumber = 0;
        }
        return buildNumber;
    }

    @Override
    public List<UpgradeTask> getRequiredUpgrades() {
        ArrayList<UpgradeTask> requiredUpgrades = new ArrayList<UpgradeTask>();
        int currentBuildNumber = this.getDataBuildNumber();
        int finalBuildNumber = this.getApplicationBuildNumber();
        try {
            List<UpgradeTask> upgradeTasks = this.getUpgradeTasks();
            for (UpgradeTask upgradeTask : upgradeTasks) {
                String build = upgradeTask.getBuildNumber();
                int upgradeTaskBuildNumber = Integer.parseInt(build);
                if (upgradeTaskBuildNumber <= currentBuildNumber || upgradeTaskBuildNumber > finalBuildNumber) continue;
                requiredUpgrades.add(upgradeTask);
            }
        }
        catch (Throwable e) {
            this.logger.error("Failed to get required upgrades: " + e.getMessage(), e);
        }
        return requiredUpgrades;
    }

    @Override
    public boolean needUpgrade() {
        return this.getApplicationBuildNumber() != this.getDataBuildNumber();
    }

    @Override
    public Collection<String> doUpgrade() throws Exception {
        String lastSuccessfullyRanUpgrade = null;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.needUpgrade()) {
            for (UpgradeTask task : this.getRequiredUpgrades()) {
                this.logger.info("Running upgrade task for build - " + task.getBuildNumber() + ": " + task.getShortDescription());
                try {
                    task.doUpgrade();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    errors.add("Upgrade task for build " + task.getBuildNumber() + " failed with exception: " + e.getMessage());
                }
                if (!task.getErrors().isEmpty()) {
                    errors.addAll(task.getErrors());
                    break;
                }
                if (!errors.isEmpty()) continue;
                lastSuccessfullyRanUpgrade = task.getBuildNumber();
            }
            if (errors.isEmpty()) {
                this.setCurrentBuildNumber(this.getApplicationBuildNumber());
            } else if (lastSuccessfullyRanUpgrade != null) {
                this.setCurrentBuildNumber(Integer.parseInt(lastSuccessfullyRanUpgrade));
            }
            this.flushAndClearHibernate();
        }
        return errors;
    }

    protected void flushAndClearHibernate() {
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        this.clearCaches();
    }

    void clearCaches() {
        this.logger.info("Clearing non-persisted caches after upgrade");
        ImmutableSet cacheNames = ImmutableSet.copyOf((Object[])this.cacheManager.getCacheNames());
        for (String cacheName : Sets.difference((Set)cacheNames, RETAINED_CACHES_ON_UPGRADE)) {
            this.logger.debug("Clearing cache: {}", (Object)cacheName);
            this.cacheManager.getCache(cacheName).removeAll();
        }
        this.logger.info("These persisted caches have been left uncleared: {}", (Object)Sets.intersection((Set)cacheNames, RETAINED_CACHES_ON_UPGRADE));
    }

    private void setCurrentBuildNumber(int buildNumber) {
        try {
            this.propertyManager.setBuildNumber(Integer.valueOf(buildNumber));
            this.getBootstrapManager().setBuildNumber(Integer.toString(buildNumber));
            this.getBootstrapManager().save();
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public CrowdBootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (CrowdBootstrapManager)BootstrapUtils.getBootstrapManager();
        }
        return this.bootstrapManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public List<UpgradeTask> getUpgradeTasks() {
        return this.upgradeTasks;
    }

    public void setUpgradeTasks(List<UpgradeTask> upgradeTasks) {
        this.upgradeTasks = upgradeTasks;
    }
}

