/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.threadlocal;

import com.atlassian.crowd.manager.threadlocal.ThreadLocalState;
import com.atlassian.crowd.manager.threadlocal.ThreadLocalStateAccessor;
import com.atlassian.crowd.plugin.web.ExecutingHttpRequest;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class CrowdThreadLocalStateAccessor
implements ThreadLocalStateAccessor {
    @Override
    public ThreadLocalState getState() {
        SecurityContext context = SecurityContextHolder.getContext();
        ActionContext actionContext = ServletActionContext.getContext();
        HttpServletRequest request = ExecutingHttpRequest.get();
        HttpServletResponse response = ExecutingHttpRequest.getResponse();
        return new ThreadLocalState(context, actionContext, request, response);
    }

    @Override
    public void setState(ThreadLocalState state) {
        SecurityContextHolder.setContext((SecurityContext)state.getSecurityContext());
        ServletActionContext.setContext((ActionContext)state.getActionContext());
        ExecutingHttpRequest.set(state.getRequest(), state.getResponse());
    }

    @Override
    public void clearState() {
        SecurityContextHolder.clearContext();
        ServletActionContext.setContext(null);
        ExecutingHttpRequest.clear();
    }
}

