/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.backup;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.manager.backup.BackupFileStore;
import com.atlassian.crowd.manager.backup.BackupJob;
import com.atlassian.crowd.manager.backup.BackupManager;
import com.atlassian.crowd.manager.backup.BackupScheduler;
import com.atlassian.crowd.manager.backup.ScheduledBackupException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzBackupScheduler
implements BackupScheduler {
    private static final Logger log = LoggerFactory.getLogger(QuartzBackupScheduler.class);
    public static final String ENABLED_PROPERTY = "backup.scheduled.enabled";
    public static final String HOUR_PROPERTY = "backup.scheduled.time.hour";
    public static final String JOB_NAME = "AutomatedBackup";
    public static final String GROUP_NAME = "AutomatedBackup";
    private final Scheduler scheduler;
    private final PropertyManager propertyManager;
    private final BackupManager backupManager;
    private final BackupFileStore backupFileStore;

    public QuartzBackupScheduler(Scheduler scheduler, PropertyManager propertyManager, BackupManager backupManager, EventPublisher eventPublisher, BackupFileStore backupFileStore) {
        this.scheduler = scheduler;
        this.propertyManager = propertyManager;
        this.backupManager = backupManager;
        this.backupFileStore = backupFileStore;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public synchronized void onApplicationStart(ApplicationStartedEvent event) {
        log.debug("Got ApplicationStarted event");
        int hourToRun = this.getHourToRun();
        try {
            this.scheduler.addJob(this.buildJobDetail(), true);
            if (this.isEnabled()) {
                this.scheduleJob(hourToRun);
            }
        }
        catch (Exception e) {
            log.error("Unable to schedule the Automated Backup job. The automated backups will not run", (Throwable)e);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.propertyManager.getBoolean(ENABLED_PROPERTY, true);
    }

    @Override
    public synchronized void enable() throws ScheduledBackupException {
        if (!this.isEnabled()) {
            try {
                this.scheduleJob(this.getHourToRun());
                this.propertyManager.setProperty(ENABLED_PROPERTY, Boolean.TRUE.toString());
            }
            catch (Exception e) {
                throw new ScheduledBackupException("Error while enabling automated backups");
            }
        }
    }

    @Override
    public void disable() throws ScheduledBackupException {
        if (this.isEnabled()) {
            try {
                this.scheduler.unscheduleJob("AutomatedBackup", "AutomatedBackup");
                this.propertyManager.setProperty(ENABLED_PROPERTY, Boolean.FALSE.toString());
            }
            catch (SchedulerException e) {
                throw new ScheduledBackupException("Error while disabling automated backups", e);
            }
        }
    }

    @Override
    public int getHourToRun() {
        return this.propertyManager.getInt(HOUR_PROPERTY, 2);
    }

    @Override
    public synchronized void setHourToRun(int timeOfDay) throws ScheduledBackupException {
        Preconditions.checkArgument((timeOfDay >= 0 && timeOfDay <= 23 ? 1 : 0) != 0, (Object)"The time of day must be between 0 and 23");
        try {
            if (this.isEnabled()) {
                this.scheduleJob(timeOfDay);
            }
            this.propertyManager.setProperty(HOUR_PROPERTY, Integer.toString(timeOfDay));
        }
        catch (Exception e) {
            throw new ScheduledBackupException("Error while scheduling the automated backup job", e);
        }
    }

    protected void scheduleJob(int timeOfDay) throws SchedulerException, ParseException {
        String cron = this.getCronExpression(timeOfDay);
        log.info("Registering automated backup Quartz job with trigger schedule {}", (Object)cron);
        Trigger trigger = this.buildTrigger(cron);
        this.scheduler.unscheduleJob("AutomatedBackup", "AutomatedBackup");
        this.scheduler.scheduleJob(trigger);
    }

    protected JobDetail buildJobDetail() {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName("AutomatedBackup");
        jobDetail.setGroup("AutomatedBackup");
        jobDetail.setJobClass(BackupJob.class);
        jobDetail.setVolatility(true);
        jobDetail.setDurability(true);
        jobDetail.setJobDataMap(new JobDataMap((Map)ImmutableMap.of((Object)"backupManager", (Object)this.backupManager, (Object)"backupFileStore", (Object)this.backupFileStore)));
        return jobDetail;
    }

    protected Trigger buildTrigger(String cron) throws ParseException {
        return new CronTrigger("AutomatedBackup", "AutomatedBackup", "AutomatedBackup", "AutomatedBackup", cron);
    }

    private String getCronExpression(int hourOfDay) {
        return "0 0 " + hourOfDay + " * * ?";
    }
}

