/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.backup;

import com.atlassian.crowd.manager.backup.BackupFileStore;
import com.atlassian.crowd.manager.backup.BackupManager;
import com.atlassian.crowd.migration.ExportException;
import java.util.concurrent.TimeUnit;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class BackupJob
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(BackupJob.class);
    private BackupManager backupManager;
    private BackupFileStore backupFileStore;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        try {
            String fileName = this.backupManager.generateAutomatedBackupFileName();
            log.info("Starting scheduled backup to file {}...", (Object)fileName);
            long timeTaken = this.backupManager.backup(fileName, true);
            log.info("Scheduled backup to file '{}' finished in {} seconds", (Object)this.backupManager.getBackupFileFullPath(fileName), (Object)TimeUnit.MILLISECONDS.toSeconds(timeTaken));
            this.backupFileStore.cleanUpAutomatedBackupFiles();
        }
        catch (ExportException e) {
            log.error("Error while executing scheduled backup", (Throwable)e);
        }
    }

    public void setBackupManager(BackupManager backupManager) {
        this.backupManager = backupManager;
    }

    public void setBackupFileStore(BackupFileStore backupFileStore) {
        this.backupFileStore = backupFileStore;
    }
}

