/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.BaseDelegatingJdbcImporter;
import com.atlassian.crowd.importer.importers.CrowdifiedJiraImporter;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.importers.JdbcImporter;
import com.atlassian.crowd.importer.importers.JiraLegacyImporter;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.util.PasswordHelper;
import org.springframework.jdbc.BadSqlGrammarException;

public class JiraImporter
extends BaseDelegatingJdbcImporter {
    private static final String CROWD_USER_COUNT = "SELECT COUNT(id)  FROM cwd_user";

    public JiraImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager, passwordHelper);
    }

    private boolean isUsingCrowdUser() {
        try {
            return this.jdbcTemplate.queryForInt(CROWD_USER_COUNT) > 0;
        }
        catch (BadSqlGrammarException bsge) {
            return false;
        }
    }

    @Override
    public Importer determineImporter(Configuration configuration) throws ImporterException {
        if (configuration == null || !this.getConfigurationType().isInstance(configuration)) {
            throw new IllegalArgumentException("The supplied configuration was of the incorrect type for this Importer, should have been: " + this.getConfigurationType().getCanonicalName());
        }
        this.init(configuration);
        JdbcImporter importer = this.isUsingCrowdUser() ? new CrowdifiedJiraImporter(this.directoryManager, this.passwordHelper) : new JiraLegacyImporter(this.directoryManager, this.passwordHelper);
        return importer;
    }
}

