/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.config;

import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Configuration {
    protected Boolean overwriteTarget;
    private Long directoryID;
    private String application;
    private Boolean importPasswords;
    private Boolean importNestedGroups;

    public Configuration() {
        this.overwriteTarget = Boolean.FALSE;
        this.importPasswords = Boolean.TRUE;
        this.importNestedGroups = Boolean.FALSE;
    }

    public Configuration(Long directoryID, String application, Boolean importPasswords, Boolean overwriteTarget) {
        this.directoryID = directoryID;
        this.application = application;
        this.importPasswords = importPasswords;
        this.overwriteTarget = overwriteTarget;
        this.importNestedGroups = Boolean.FALSE;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public Long getDirectoryID() {
        return this.directoryID;
    }

    public void setDirectoryID(Long directoryID) {
        this.directoryID = directoryID;
    }

    public Boolean isOverwriteTarget() {
        return this.overwriteTarget;
    }

    public Boolean isImportPasswords() {
        return this.importPasswords;
    }

    public void setImportPasswords(Boolean importPasswords) {
        this.importPasswords = importPasswords;
    }

    public Boolean getImportNestedGroups() {
        return this.importNestedGroups;
    }

    public void setImportNestedGroups(Boolean importNestedGroups) {
        this.importNestedGroups = importNestedGroups;
    }

    public void isValid() throws ImporterConfigurationException {
        if (StringUtils.isBlank((CharSequence)this.application) || this.directoryID == null || this.importPasswords == null) {
            throw new ImporterConfigurationException("A required Configuration value was null: " + this);
        }
    }

    public void setOverwriteTarget(Boolean overwriteTarget) {
        this.overwriteTarget = overwriteTarget == null ? Boolean.FALSE : overwriteTarget;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.application != null ? !this.application.equals(that.application) : that.application != null) {
            return false;
        }
        if (this.directoryID != null ? !this.directoryID.equals(that.directoryID) : that.directoryID != null) {
            return false;
        }
        return !(this.importPasswords != null ? !this.importPasswords.equals(that.importPasswords) : that.importPasswords != null);
    }

    public int hashCode() {
        int result = this.directoryID != null ? this.directoryID.hashCode() : 0;
        result = 31 * result + (this.application != null ? this.application.hashCode() : 0);
        result = 31 * result + (this.importPasswords != null ? this.importPasswords.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Directory ID", (Object)this.directoryID).append("Application", (Object)this.application).append("ImportPasswords", (Object)this.importPasswords).toString();
    }
}

