/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.listener;

import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.event.api.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetLdapConnectionSettingsListener {
    private static final Logger log = LoggerFactory.getLogger(SetLdapConnectionSettingsListener.class);
    private PropertyManager propertyManager;

    @EventListener
    public void handleEvent(ApplicationReadyEvent event) throws ObjectNotFoundException {
        this.setLdapSystemProperty("com.sun.jndi.ldap.connect.pool.initsize");
        this.setLdapSystemProperty("com.sun.jndi.ldap.connect.pool.prefsize");
        this.setLdapSystemProperty("com.sun.jndi.ldap.connect.pool.maxsize");
        this.setLdapSystemProperty("com.sun.jndi.ldap.connect.pool.timeout");
        this.setLdapSystemProperty("com.sun.jndi.ldap.connect.pool.protocol");
        this.setLdapSystemProperty("com.sun.jndi.ldap.connect.pool.authentication");
    }

    private void setLdapSystemProperty(String propertyKey) throws ObjectNotFoundException {
        log.debug("Setting system-wide LDAP connection pool property: <" + propertyKey + "> with value: <" + this.propertyManager.getProperty(propertyKey) + ">");
        System.setProperty(propertyKey, this.propertyManager.getProperty(propertyKey));
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }
}

