/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.console.action;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.console.action.ActionHelper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.xwork.XsrfTokenGenerator;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.model.WebLink;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.naming.CommunicationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAction
extends ActionSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Integer tab = 1;
    protected boolean initialLoad = true;
    protected String actionMessageAlertColor;
    public static final String ALERT_GREEN = "green";
    public static final String ALERT_YELLOW = "yellow";
    public static final String ALERT_RED = "red";
    public static final String ALERT_BLUE = "blue";
    protected PropertyManager propertyManager;
    protected DirectoryManager directoryManager;
    protected ApplicationManager applicationManager;
    protected CrowdLicenseManager crowdLicenseManager;
    private WebResourceManager webResourceManager;
    protected CrowdUserDetailsService crowdUserDetailsService;
    private WebInterfaceManager webInterfaceManager;
    private Integer currentLicenseResourceTotal = new Integer(0);
    private static final String DEFAULT_IMAGE_LOCATION = "/console/images/icons/16x16/16";
    private static final String ICON_IMAGE_TYPE = ".png";
    protected ApplicationService applicationService;
    protected TokenAuthenticationManager tokenAuthenticationManager;
    protected ClientProperties clientProperties;
    private XsrfTokenGenerator xsrfTokenGenerator;
    private Application crowdApplication;
    private ActionHelper actionHelper;

    public String doDefault() throws Exception {
        return "success";
    }

    protected boolean hasAdminRole(CrowdUserDetails userDetails) {
        return this.actionHelper.hasAdminRole(userDetails);
    }

    public boolean isAuthenticated() {
        return this.actionHelper != null && this.actionHelper.isAuthenticated();
    }

    public boolean isAdmin() {
        return this.actionHelper != null && this.actionHelper.isAdmin();
    }

    public String getSitemeshPageProperty(String propertyName) {
        return this.actionHelper.getSitemeshPageProperty(propertyName);
    }

    public Map<String, String> getSitemeshPageProperties() {
        return this.actionHelper.getSitemeshPageProperties();
    }

    public String getUserName() throws InvalidUserException {
        if (!this.isAuthenticated()) {
            return null;
        }
        if (this.getRemoteUser() == null) {
            return "";
        }
        return StringUtils.isNotBlank((CharSequence)this.getRemoteUser().getDisplayName()) ? this.getRemoteUser().getDisplayName() : this.getRemoteUser().getName();
    }

    public UserWithAttributes getRemoteUser() {
        return this.actionHelper != null ? this.actionHelper.getRemoteUser() : null;
    }

    protected HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    protected HttpServletRequest getHttpRequest() {
        return ServletActionContext.getRequest();
    }

    public Integer getTab() {
        return this.tab;
    }

    public void setTab(Integer tab) {
        this.tab = tab;
    }

    public boolean isInitialLoad() {
        return this.initialLoad;
    }

    public CrowdLicense getLicense() {
        return this.actionHelper.getLicense();
    }

    public boolean isEvaluation() {
        return this.actionHelper != null && this.actionHelper.isEvaluation();
    }

    public boolean isSubscription() {
        return this.actionHelper != null && this.actionHelper.isSubscription();
    }

    public boolean isWithinGracePeriod() {
        return this.actionHelper != null && this.actionHelper.isWithinGracePeriod();
    }

    public boolean isLicenseExpired() {
        return this.actionHelper != null && this.actionHelper.isLicenseExpired();
    }

    public String getActionMessageAlertColor() {
        if (StringUtils.isEmpty((CharSequence)this.actionMessageAlertColor)) {
            return ALERT_YELLOW;
        }
        return this.actionMessageAlertColor;
    }

    public void addActionMessage(String color, String message) {
        this.actionMessageAlertColor = color;
        this.addActionMessage(message);
    }

    public List<WebItemModuleDescriptor> getWebItemsForSection(String sectionName) {
        return this.actionHelper.getWebItemsForSection(sectionName);
    }

    public List<WebSectionModuleDescriptor> getWebSectionsForLocation(String location) {
        return this.actionHelper.getWebSectionsForLocation(location);
    }

    public String renderFreemarkerTemplate(String templateString) {
        return this.webInterfaceManager.getWebFragmentHelper().renderVelocityFragment(templateString, this.getWebFragmentsContextMap());
    }

    public Map<String, Object> getWebFragmentsContextMap() {
        return this.actionHelper != null ? this.actionHelper.getWebFragmentsContextMap() : Collections.emptyMap();
    }

    public String getDisplayableLink(WebLink link) {
        return this.actionHelper.getDisplayableLink(link);
    }

    public String getLink(WebLink link) {
        return link.getDisplayableUrl(this.getHttpRequest(), Collections.EMPTY_MAP);
    }

    public Directory directory(long directoryID) {
        try {
            return this.directoryManager.findDirectoryById(directoryID);
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            this.addActionError(e.getMessage());
            return null;
        }
    }

    protected void addActionError(Throwable t) {
        if (BaseAction.isBadReferralException(t)) {
            this.addActionError(this.getText("error.suggestion.badnodereferral"));
        }
        this.addActionError(t.getMessage());
    }

    static boolean isBadReferralException(Throwable e) {
        while (e != null) {
            if (BaseAction.isExceptionThrownInLdapReferralContext(e)) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    private static boolean isExceptionThrownInLdapReferralContext(Throwable e) {
        if (e instanceof CommunicationException) {
            StackTraceElement[] st = e.getStackTrace();
            return st.length >= 1 && st[0].getClassName().equals("com.sun.jndi.ldap.LdapReferralContext");
        }
        return false;
    }

    public boolean containsErrorMessages() {
        return this.getActionErrors() != null && !this.getActionErrors().isEmpty();
    }

    public boolean containsActionMessages() {
        return this.getActionMessages() != null && !this.getActionMessages().isEmpty();
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setCrowdUserDetailsService(CrowdUserDetailsService crowdUserDetailsService) {
        this.crowdUserDetailsService = crowdUserDetailsService;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public WebInterfaceManager getWebInterfaceManager() {
        return this.webInterfaceManager;
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    protected CrowdBootstrapManager getBootstrapManager() {
        if (this.actionHelper != null) {
            return this.actionHelper.getBootstrapManager();
        }
        return (CrowdBootstrapManager)BootstrapUtils.getBootstrapManager();
    }

    public boolean isAtResourceLimit() {
        return this.crowdLicenseManager.isResourceTotalOverLimit(90.0f, this.getCurrentLicenseResourceTotal());
    }

    public Integer getCurrentLicenseResourceTotal() {
        if (this.currentLicenseResourceTotal == null || this.currentLicenseResourceTotal == 0) {
            this.currentLicenseResourceTotal = new Integer(this.propertyManager.getCurrentLicenseResourceTotal());
        }
        return this.currentLicenseResourceTotal;
    }

    public String getImageTitle(boolean active, ApplicationType applicationType) {
        String imageI8n = "application." + applicationType.toString().toLowerCase(Locale.ENGLISH) + (active ? ".enabled" : ".disabled");
        return this.getText(imageI8n);
    }

    public String getImageLocation(boolean active, ApplicationType applicationType) {
        return ServletActionContext.getRequest().getContextPath() + DEFAULT_IMAGE_LOCATION + applicationType.toString().toLowerCase(Locale.ENGLISH) + (active ? "" : "_disabled") + ICON_IMAGE_TYPE;
    }

    protected boolean authorisedToAccessCrowdConsole(Long directoryId, String name) throws DirectoryNotFoundException, UserNotFoundException {
        List authorisedApplications = null;
        try {
            authorisedApplications = this.tokenAuthenticationManager.findAuthorisedApplications(this.directoryManager.findUserByName(directoryId.longValue(), name), this.clientProperties.getApplicationName());
        }
        catch (OperationFailedException ex) {
            this.logger.error("Underlying directory implementation failed to execute the operation");
            return false;
        }
        catch (ApplicationNotFoundException e) {
            this.logger.error("Could not find the application", (Throwable)e);
            return false;
        }
        String crowdConsoleName = IdentifierUtils.toLowerCase((String)this.getText("application.name"));
        boolean authorised = false;
        for (int i = 0; i < authorisedApplications.size() && !authorised; ++i) {
            Application application = (Application)authorisedApplications.get(i);
            if (!application.getName().equals(crowdConsoleName)) continue;
            authorised = true;
        }
        return authorised;
    }

    public boolean authorisedToAccessCrowdAdminConsole(DirectoryMapping directoryMapping, Long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException {
        boolean allowAllToAuthenticate = directoryMapping.isAllowAllToAuthenticate();
        directoryMapping.setAllowAllToAuthenticate(false);
        boolean hasAdminAccess = this.authorisedToAccessCrowdConsole(directoryId, username);
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        return hasAdminAccess;
    }

    public String getText(String i18nKey, List args, boolean encode) {
        if (encode) {
            args = Lists.transform((List)args, (Function)new Function(){

                public Object apply(Object from) {
                    return from instanceof String ? TextUtils.htmlEncode((String)((String)from)) : from;
                }
            });
        }
        return super.getText(i18nKey, args);
    }

    public String getXsrfTokenName() {
        return this.xsrfTokenGenerator.getXsrfTokenName();
    }

    public String getXsrfToken() {
        return this.xsrfTokenGenerator.generateToken(this.getHttpRequest());
    }

    public String getText(String i18nKey, List args) {
        return this.getText(i18nKey, args, true);
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    public void setTokenAuthenticationManager(TokenAuthenticationManager tokenAuthenticationManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    @Nullable
    protected String getPasswordComplexityMessage(long directoryId) {
        String passwordComplexityRequirementMessage;
        Directory dir = this.directory(directoryId);
        if (dir != null && !StringUtils.isBlank((CharSequence)(passwordComplexityRequirementMessage = dir.getValue("password_complexity_message")))) {
            return passwordComplexityRequirementMessage;
        }
        return null;
    }

    protected Application getCrowdApplication() throws ApplicationNotFoundException {
        if (this.crowdApplication == null) {
            this.crowdApplication = this.applicationManager.findByName(this.clientProperties.getApplicationName());
        }
        return this.crowdApplication;
    }

    @VisibleForTesting
    public void setCrowdApplication(Application crowdApplication) {
        this.crowdApplication = crowdApplication;
    }

    public void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }
}

