/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.host.spi.AbstractInternalHostApplication;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.UUID;

public class CrowdHostApplication
extends AbstractInternalHostApplication
implements InternalHostApplication {
    private final PropertyManager propertyManager;
    private final TypeAccessor typeAccessor;
    private final ClientProperties applicationProperties;
    private final CrowdBootstrapManager crowdBootstrapManager;

    public CrowdHostApplication(PropertyManager propertyManager, PluginAccessor pluginAccessor, TypeAccessor typeAccessor, ClientProperties applicationProperties, CrowdBootstrapManager crowdBootstrapManager) {
        super(pluginAccessor);
        this.propertyManager = propertyManager;
        this.typeAccessor = typeAccessor;
        this.applicationProperties = applicationProperties;
        this.crowdBootstrapManager = crowdBootstrapManager;
    }

    public URI getDocumentationBaseUrl() {
        return URI.create("http://confluence.atlassian.com/display/APPLINKS");
    }

    public String getName() {
        try {
            return this.propertyManager.getDeploymentTitle();
        }
        catch (PropertyManagerException e) {
            return ApplicationType.CROWD.getDisplayName();
        }
    }

    public com.atlassian.applinks.api.ApplicationType getType() {
        return this.typeAccessor.getApplicationType(CrowdApplicationType.class);
    }

    public Iterable<EntityReference> getLocalEntities() {
        return ImmutableList.of();
    }

    public boolean doesEntityExist(String s, Class<? extends EntityType> aClass) {
        return false;
    }

    public boolean doesEntityExistNoPermissionCheck(String s, Class<? extends EntityType> aClass) {
        return false;
    }

    public EntityReference toEntityReference(Object o) {
        return null;
    }

    public EntityReference toEntityReference(String s, Class<? extends EntityType> aClass) {
        return null;
    }

    public boolean canManageEntityLinksFor(EntityReference entityReference) {
        return false;
    }

    public boolean hasPublicSignup() {
        return false;
    }

    public ApplicationId getId() {
        String serverId = this.crowdBootstrapManager.getServerID();
        return new ApplicationId(UUID.nameUUIDFromBytes(serverId.getBytes(Charsets.UTF_8)).toString());
    }

    public URI getBaseUrl() {
        return URI.create(this.applicationProperties.getBaseURL());
    }
}

