/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.util.SystemInfoHelper;
import com.atlassian.crowd.util.build.BuildUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Calendar;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.springframework.web.context.ServletContextAware;

public class SystemInfoHelperImpl
implements SystemInfoHelper,
ServletContextAware {
    private ServletContext servletContext;
    private PropertyManager propertyManager;
    private CrowdBootstrapManager bootstrapManager;
    private DirectoryManager directoryManager;

    public SystemInfoHelperImpl() {
    }

    public SystemInfoHelperImpl(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Override
    public String getApplicationServer() {
        String applicationServer = null;
        if (this.servletContext != null) {
            applicationServer = this.servletContext.getServerInfo();
        } else if (ServletActionContext.getServletContext() != null) {
            applicationServer = ServletActionContext.getServletContext().getServerInfo();
        }
        return applicationServer;
    }

    @Override
    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    @Override
    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    @Override
    public long getUsedMemory() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
    }

    @Override
    public String getOperatingSystem() {
        return System.getProperty("os.name") + System.getProperty("os.version");
    }

    @Override
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    @Override
    public String getJavaRuntime() {
        return System.getProperty("java.vm.name");
    }

    @Override
    public String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    @Override
    public String getApplicationUsername() {
        return System.getProperty("user.name");
    }

    @Override
    public String getArchitecture() {
        return System.getProperty("os.arch");
    }

    @Override
    public String getCrowdVersion() {
        return BuildUtils.getVersion();
    }

    @Override
    public String getTimeZone() {
        return Calendar.getInstance().getTimeZone().getDisplayName();
    }

    @Override
    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    @Override
    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @Override
    public String getServerId() {
        return this.getBootstrapManager().getServerID();
    }

    @Override
    public String getDatabaseJdbcDriver() {
        return this.getBootstrapManager().getString("hibernate.connection.driver_class");
    }

    @Override
    public String getDatabaseJdbcUsername() {
        return this.getBootstrapManager().getString("hibernate.connection.username");
    }

    @Override
    public String getDatabaseJdbcUrl() {
        return this.getBootstrapManager().getString("hibernate.connection.url");
    }

    @Override
    public String getDatabaseHibernateDialect() {
        return this.getBootstrapManager().getString("hibernate.dialect");
    }

    @Override
    public String getDatabaseDatasourceJndiName() {
        return this.getBootstrapManager().getString("hibernate.connection.datasource");
    }

    @Override
    public boolean isDatabaseDatasource() {
        return this.getDatabaseDatasourceJndiName() != null;
    }

    @Override
    public void printMinimalSystemInfo(Logger logger) {
        logger.info("System Information:");
        logger.info("\tTimezone: " + this.getTimeZone());
        logger.info("\tJava Version: " + this.getJavaVersion());
        logger.info("\tJava Vendor: " + this.getJavaVendor());
        logger.info("\tJVM Version: " + this.getJavaVMVersion());
        logger.info("\tJVM Vendor: " + this.getJavaVMVendor());
        logger.info("\tJVM Runtime: " + this.getJavaRuntime());
        logger.info("\tUsername: " + this.getApplicationUsername());
        logger.info("\tOperating System: " + this.getOperatingSystem());
        logger.info("\tArchitecture: " + this.getArchitecture());
        logger.info("\tFile Encoding: " + this.getFileEncoding());
        logger.info("JVM Statistics:");
        logger.info("\tTotal Memory: " + this.getTotalMemory() + "MB");
        logger.info("\tUsed Memory: " + this.getUsedMemory() + "MB");
        logger.info("\tFree Memory: " + this.getFreeMemory() + "MB");
        logger.info("Runtime Information:");
        logger.info("\tVersion: 2.6.1-m2");
        logger.info("\tBuild Number: 603");
        logger.info("\tBuild Date: 19-02-2013");
    }

    @Override
    public void printSystemInfo(Logger logger) {
        this.printMinimalSystemInfo(logger);
        logger.info("\tApplication Server: " + this.getApplicationServer());
        logger.info("Database Information:");
        if (this.isDatabaseDatasource()) {
            logger.info("\tDatasource JNDI: " + this.getDatabaseDatasourceJndiName());
        } else {
            logger.info("\tJDBC URL: " + this.getDatabaseJdbcUrl());
            logger.info("\tJDBC Driver: " + this.getDatabaseJdbcDriver());
            logger.info("\tJDBC Username: " + this.getDatabaseJdbcUsername());
        }
        logger.info("\tHibernate Dialect: " + this.getDatabaseHibernateDialect());
        logger.info("License Information:");
        logger.info("\tLicense Server ID: " + this.getServerId());
        logger.info("Directories:");
        StringBuffer directoryList = new StringBuffer();
        for (Directory directory : this.getDirectoryManager().findAllDirectories()) {
            String directoryType = directory.getImplementationClass();
            directoryType = directoryType.substring(directoryType.lastIndexOf(".") + 1, directoryType.length());
            directoryList.append("\t").append(directory.getName()).append(" (").append(directoryType).append(")").append("\n");
        }
        logger.info(directoryList.toString());
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public CrowdBootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

