/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.util.I18nHelper;
import java.util.ArrayList;
import java.util.Collection;

public class UpgradeTask422
implements UpgradeTask {
    private final Collection<String> errors = new ArrayList<String>();
    private PropertyManager propertyManager;
    private I18nHelper i18nHelper;

    @Override
    public String getBuildNumber() {
        return "422";
    }

    @Override
    public String getShortDescription() {
        return "Add default forgotten username mail template";
    }

    @Override
    public void doUpgrade() throws Exception {
        if (this.needsUpgrade()) {
            this.propertyManager.setProperty("email.template.forgotten.username", this.i18nHelper.getText("mailtemplate.template.forgotten.username.text"));
        }
    }

    private boolean needsUpgrade() {
        try {
            this.propertyManager.getProperty("email.template.forgotten.username");
            return false;
        }
        catch (ObjectNotFoundException e) {
            return true;
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

