/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpgradeTask361
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private final Collection<String> errors = new ArrayList<String>();

    @Override
    public String getBuildNumber() {
        return "361";
    }

    @Override
    public String getShortDescription() {
        return "Setting ldap.roles.disabled=false for directories without the property set";
    }

    @Override
    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            String disabled;
            if (DirectoryType.CONNECTOR != directory.getType() || (disabled = directory.getValue("ldap.roles.disabled")) != null) continue;
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            directoryToUpdate.setAttribute("ldap.roles.disabled", Boolean.FALSE.toString());
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

