/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpgradeTask216
implements UpgradeTask {
    private Collection errors = new ArrayList();
    private DirectoryManager directoryManager;

    @Override
    public String getBuildNumber() {
        return "216";
    }

    @Override
    public String getShortDescription() {
        return "Adding an ldap.user.username.rdn to directories that lack it. Will be set the same as ldap.user.username except for Active Directory.";
    }

    @Override
    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            if (directory.getValue("ldap.user.username.rdn") != null) continue;
            String rdnValue = "com.atlassian.crowd.integration.directory.connector.MicrosoftActiveDirectory".equals(directory.getImplementationClass()) || "com.atlassian.crowd.directory.MicrosoftActiveDirectory".equals(directory.getImplementationClass()) ? "cn" : directory.getValue("ldap.user.username");
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            directoryToUpdate.setAttribute("ldap.user.username.rdn", rdnValue);
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

