/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.factory;

import com.atlassian.crowd.plugin.PluginDirectoryLocator;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.File;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public class BundledPluginLoaderFactory
implements FactoryBean {
    private static final Logger log = LoggerFactory.getLogger(BundledPluginLoaderFactory.class);
    private final PluginDirectoryLocator pluginDirectoryLocator;
    private final List<PluginFactory> pluginFactories;
    private final PluginEventManager pluginEventManager;
    private final String bundledPluginFileName;
    private static final String ATLASSIAN_PLUGINS_BUNDLED_DISABLE = "atlassian.plugins.bundled.disable";

    public BundledPluginLoaderFactory(PluginDirectoryLocator pluginDirectoryLocator, List<PluginFactory> pluginFactories, PluginEventManager pluginEventManager, String bundledPluginFileName) {
        this.pluginDirectoryLocator = pluginDirectoryLocator;
        this.pluginFactories = pluginFactories;
        this.pluginEventManager = pluginEventManager;
        this.bundledPluginFileName = bundledPluginFileName;
    }

    public Object getObject() throws Exception {
        if (!Boolean.getBoolean(ATLASSIAN_PLUGINS_BUNDLED_DISABLE)) {
            File frameworkBundlesDirectory = this.pluginDirectoryLocator.getBundledPluginsDirectory();
            URL bundledPluginsURL = ClassLoaderUtils.getResource((String)this.bundledPluginFileName, this.getClass());
            if (Boolean.getBoolean("atlassian.dev.mode")) {
                log.info("We are in dev mode, using the following location for plugins <" + bundledPluginsURL.toExternalForm() + ">");
            }
            if (bundledPluginsURL == null) {
                throw new IllegalStateException("Could not load <" + this.bundledPluginFileName + "> from classpath");
            }
            return new BundledPluginLoader(bundledPluginsURL, frameworkBundlesDirectory, this.pluginFactories, this.pluginEventManager);
        }
        log.warn("Bundled plugins have been disabled. Removing bundled plugin loader.");
        return null;
    }

    public Class getObjectType() {
        return BundledPluginLoader.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

