/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.verify;

import com.atlassian.crowd.migration.verify.Verifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.math.NumberUtils;
import org.dom4j.Element;

public class VersionMismatchVerifier
implements Verifier {
    private final List<String> errors = new ArrayList<String>();

    @Override
    public void verify(Element root) {
        Element buildNumberElement = (Element)root.selectSingleNode("/crowd/ buildNumber");
        int buildNumber = NumberUtils.toInt((String)buildNumberElement.getTextTrim());
        if (buildNumber > NumberUtils.toInt((String)"603")) {
            Element buildVersionElement = (Element)root.selectSingleNode("/crowd/ version");
            this.errors.add("You cannot import XML data from a newer version of Crowd " + buildVersionElement.getTextTrim() + " (" + buildNumber + ") into an older version " + "2.6.1-m2" + " (" + "603" + ")");
        }
    }

    @Override
    public void clearState() {
        this.errors.clear();
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }
}

