/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.migration.GenericMapper;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericLegacyImporter
extends GenericMapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss Z yyyy";
    public static final String GENERIC_XML_ID = "id";
    public static final String GENERIC_XML_NAME = "name";
    public static final String GENERIC_XML_ACTIVE = "active";
    public static final String GENERIC_XML_CONCEPTION = "conception";
    public static final String GENERIC_XML_LASTMODIFIED = "lastModified";
    public static final String GENERIC_XML_ATTRIBUTES_NODE = "attributes";
    public static final String GENERIC_XML_ATTRIBUTE = "attribute";
    public static final String GENERIC_XML_ATTRIBUTE_ID = "attributeId";
    public static final String GENERIC_XML_ATTRIBUTE_VALUES = "attributeValues";
    public static final String GENERIC_XML_ATTRIBUTE_VALUE = "attributeValue";
    public static final String GENERIC_XML_ATTRIBUTE_KEY = "attributeKey";
    private DirectoryManager directoryManager;

    public GenericLegacyImporter(SessionFactory sessionFactory, BatchProcessor batchProcessor) {
        super(sessionFactory, batchProcessor);
    }

    protected InternalEntityTemplate getInternalEntityTemplateFromLegacyXml(Element element) {
        InternalEntityTemplate template = new InternalEntityTemplate();
        template.setId(Long.valueOf(Long.parseLong(element.element(GENERIC_XML_ID).getText())));
        template.setName(element.element(GENERIC_XML_NAME).getText());
        template.setCreatedDate(this.getDateFromXml(element.element(GENERIC_XML_CONCEPTION).getText()));
        template.setUpdatedDate(this.getDateFromXml(element.element(GENERIC_XML_LASTMODIFIED).getText()));
        template.setActive(Boolean.parseBoolean(element.element(GENERIC_XML_ACTIVE).getText()));
        return template;
    }

    protected Map<String, Set<String>> getMultiValuedAttributesMapFromXml(Element element) {
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        Element attributesNode = element.element(GENERIC_XML_ATTRIBUTES_NODE);
        if (attributesNode != null && attributesNode.hasContent()) {
            Iterator iterator = attributesNode.elementIterator(GENERIC_XML_ATTRIBUTE);
            while (iterator.hasNext()) {
                Element attributeElement = (Element)iterator.next();
                String key = attributeElement.attributeValue(GENERIC_XML_ATTRIBUTE_KEY);
                Element attributeValuesElement = attributeElement.element(GENERIC_XML_ATTRIBUTE_VALUES);
                if (attributeValuesElement == null) continue;
                String attributeId = attributeValuesElement.attributeValue(GENERIC_XML_ATTRIBUTE_ID);
                HashSet<String> values = new HashSet<String>();
                Iterator attributeValuesIter = attributeValuesElement.elementIterator(GENERIC_XML_ATTRIBUTE_VALUE);
                while (attributeValuesIter.hasNext()) {
                    Element attributeValue = (Element)attributeValuesIter.next();
                    values.add(attributeValue.getText());
                }
                attributes.put(key, values);
            }
        }
        return attributes;
    }

    protected Map<String, String> getSingleValuedAttributesMapFromXml(Element element) {
        Map<String, Set<String>> attributes = this.getMultiValuedAttributesMapFromXml(element);
        HashMap<String, String> singleValuedAttributes = new HashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : attributes.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            singleValuedAttributes.put(entry.getKey(), entry.getValue().iterator().next());
        }
        return singleValuedAttributes;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    protected PasswordCredential getPasswordCredentialFromXml(Element parentElement) {
        Element credentialElement;
        Element credentialsNode = parentElement.element("credentials");
        if (credentialsNode != null && credentialsNode.hasContent() && (credentialElement = credentialsNode.element("credential")) != null) {
            return new PasswordCredential(credentialElement.getText(), true);
        }
        return new PasswordCredential("password", true);
    }
}

