/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.XmlMapper;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class DirectoryMapper
extends XmlMapper
implements Mapper {
    private final DirectoryManager directoryManager;
    protected static final String DIRECTORY_XML_ROOT = "directories";
    protected static final String DIRECTORY_XML_NODE = "directory";
    private static final String DIRECTORY_XML_DESCRIPTION = "description";
    private static final String DIRECTORY_XML_TYPE = "type";
    private static final String DIRECTORY_XML_IMPLEMENTATION_CLASS = "implementationClass";
    private static final String DIRECTORY_XML_PERMISSIONS = "permissions";
    private static final String DIRECTORY_XML_PERMISSION = "permission";

    public DirectoryMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, DirectoryManager directoryManager) {
        super(sessionFactory, batchProcessor);
        this.directoryManager = directoryManager;
    }

    @Override
    public Element exportXml(Map options) throws ExportException {
        Element directoryRoot = DocumentHelper.createElement((String)DIRECTORY_XML_ROOT);
        List directories = this.directoryManager.findAllDirectories();
        for (Directory directory : directories) {
            this.addDirectoryToXml((DirectoryImpl)directory, directoryRoot);
        }
        return directoryRoot;
    }

    protected void addDirectoryToXml(DirectoryImpl directory, Element directoryRoot) {
        Element directoryElement = directoryRoot.addElement(DIRECTORY_XML_NODE);
        this.exportInternalEntity((InternalEntity)directory, directoryElement);
        directoryElement.addElement(DIRECTORY_XML_DESCRIPTION).addText(StringUtils.defaultString((String)directory.getDescription()));
        directoryElement.addElement(DIRECTORY_XML_TYPE).addText(directory.getType().name());
        directoryElement.addElement(DIRECTORY_XML_IMPLEMENTATION_CLASS).addText(directory.getImplementationClass());
        Element permissionsElement = directoryElement.addElement(DIRECTORY_XML_PERMISSIONS);
        TreeSet operations = Sets.newTreeSet((Iterable)directory.getAllowedOperations());
        for (OperationType operation : operations) {
            permissionsElement.addElement(DIRECTORY_XML_PERMISSION).addText(operation.name());
        }
        this.exportSingleValuedAttributes((Attributes)directory, directoryElement);
    }

    @Override
    public void importXml(Element root) throws ImportException {
        Element directoryRoot = (Element)root.selectSingleNode("/crowd/directories");
        if (directoryRoot == null) {
            this.logger.error("No directories were found for importing!");
            return;
        }
        Iterator directories = directoryRoot.elementIterator();
        while (directories.hasNext()) {
            Element directoryElement = (Element)directories.next();
            DirectoryImpl directory = this.getDirectoryFromXml(directoryElement);
            this.addEntity(directory);
        }
    }

    protected DirectoryImpl getDirectoryFromXml(Element directoryElement) {
        InternalEntityTemplate template = this.getInternalEntityTemplateFromXml(directoryElement);
        DirectoryImpl directory = new DirectoryImpl(template);
        directory.setDescription(directoryElement.element(DIRECTORY_XML_DESCRIPTION).getText());
        directory.setType(DirectoryType.valueOf((String)directoryElement.element(DIRECTORY_XML_TYPE).getText()));
        directory.setImplementationClass(directoryElement.element(DIRECTORY_XML_IMPLEMENTATION_CLASS).getText());
        Element permissionsElement = directoryElement.element(DIRECTORY_XML_PERMISSIONS);
        Iterator permissions = permissionsElement.elementIterator();
        while (permissions.hasNext()) {
            Element permissionElement = (Element)permissions.next();
            directory.addAllowedOperation(OperationType.valueOf((String)permissionElement.getText()));
        }
        Map<String, String> attributes = this.getSingleValuedAttributesMapFromXml(directoryElement);
        directory.setAttributes(attributes);
        return directory;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }
}

