/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.property;

import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.property.PluginPropertyManager;
import com.atlassian.crowd.model.property.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class PluginPropertyManagerGeneric
implements PluginPropertyManager {
    public static final String KEY_PREFIX = "plugin.";
    private final PropertyDAO propertyDAO;

    public PluginPropertyManagerGeneric(PropertyDAO propertyDAO) {
        this.propertyDAO = propertyDAO;
    }

    private String generatePropertyKey(String key) {
        return key.startsWith(KEY_PREFIX) ? key : KEY_PREFIX + key;
    }

    @Override
    public String getProperty(String key, String name) throws ObjectNotFoundException {
        Validate.notEmpty((String)key, (String)"You cannot find an entry with a null/empty key");
        Validate.notEmpty((String)name, (String)"You cannot find an entry with a null/empty name");
        return this.propertyDAO.find(this.generatePropertyKey(key), name).getValue();
    }

    @Override
    public void setProperty(String key, String name, String value) {
        Validate.notEmpty((String)key, (String)"You cannot create an entry with a null/empty key");
        Validate.notEmpty((String)name, (String)"You cannot create an entry with a null/empty name");
        String propertyKey = this.generatePropertyKey(key);
        Property property = null;
        try {
            property = this.propertyDAO.find(propertyKey, name);
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        if (property == null) {
            property = new Property(propertyKey, name, value);
        } else {
            property.setValue(value);
        }
        this.propertyDAO.update(property);
    }

    @Override
    public void removeProperty(String key, String name) {
        Validate.notEmpty((String)key, (String)"You cannot remove an entry with a null/empty key");
        Validate.notEmpty((String)name, (String)"You cannot remove an entry with a null/empty name");
        if (key.startsWith(KEY_PREFIX)) {
            this.propertyDAO.remove(key, name);
        } else {
            this.propertyDAO.remove(KEY_PREFIX + key, name);
        }
    }

    @Override
    public Map<String, String> findAll(String key) {
        Validate.notEmpty((String)key, (String)"You cannot find an entries with a null/empty key");
        if (key.startsWith(KEY_PREFIX)) {
            return this.buildPropertyMap(this.propertyDAO.findAll(key));
        }
        return this.buildPropertyMap(this.propertyDAO.findAll(KEY_PREFIX + key));
    }

    private Map<String, String> buildPropertyMap(List<Property> foundProperties) {
        HashMap<String, String> convertedProperties = new HashMap<String, String>();
        for (Property property : foundProperties) {
            convertedProperties.put(property.getKey(), property.getValue());
        }
        return convertedProperties;
    }
}

