/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.config;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class DirectoryConfiguration
extends Configuration {
    private Long sourceDirectoryID;
    private static final String APPLICATION_NAME = "directory";

    public DirectoryConfiguration(Long directoryID, Long sourceDirectoryID, Boolean overwriteTarget) {
        super(directoryID, APPLICATION_NAME, Boolean.TRUE, overwriteTarget);
        this.sourceDirectoryID = sourceDirectoryID;
    }

    public Long getSourceDirectoryID() {
        return this.sourceDirectoryID;
    }

    public void setSourceDirectoryID(Long sourceDirectoryID) {
        this.sourceDirectoryID = sourceDirectoryID;
    }

    @Override
    public void isValid() throws ImporterConfigurationException {
        super.isValid();
        if (this.getDirectoryID().equals(this.getSourceDirectoryID())) {
            throw new ImporterConfigurationException("The source and target directories cannot be the same");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DirectoryConfiguration)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirectoryConfiguration that = (DirectoryConfiguration)o;
        if (this.overwriteTarget != null ? !this.overwriteTarget.equals(that.overwriteTarget) : that.overwriteTarget != null) {
            return false;
        }
        return !(this.sourceDirectoryID != null ? !this.sourceDirectoryID.equals(that.sourceDirectoryID) : that.sourceDirectoryID != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sourceDirectoryID != null ? this.sourceDirectoryID.hashCode() : 0);
        result = 31 * result + (this.overwriteTarget != null ? this.overwriteTarget.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("Target Directory ID", (Object)this.sourceDirectoryID).append("Override Target", (Object)this.overwriteTarget).toString();
    }
}

