/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.file;

import com.atlassian.crowd.dao.RefreshableDao;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class DaoRefresher
extends QuartzJobBean {
    private static final Logger logger = LoggerFactory.getLogger(DaoRefresher.class);
    private Iterable<RefreshableDao> refreshableDaos;

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Refreshing refreshable DAOs");
        for (RefreshableDao refreshableDao : this.refreshableDaos) {
            refreshableDao.refresh();
        }
    }

    public void setRefreshableDaos(Iterable<RefreshableDao> refreshableDaos) {
        this.refreshableDaos = refreshableDaos;
    }
}

