/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.upgrade.util.DirectoryImplementationsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class UpgradeTask420
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask420.class);
    private final Map<String, String> directoryImplementations = DirectoryImplementationsHelper.getDirectoryImplementations();
    private final Collection<String> errors = new ArrayList<String>();
    private DirectoryDao directoryDao;

    @Override
    public String getBuildNumber() {
        return "420";
    }

    @Override
    public String getShortDescription() {
        return "Upgrading directory class implementation names";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.getAllDirectories()) {
            if (this.isUpgradableDirectory(directory)) {
                if (log.isDebugEnabled()) {
                    log.debug("Upgrading directory " + directory);
                }
                try {
                    this.updateDirectory(directory);
                }
                catch (DataAccessException e) {
                    String errorMessage = "Could not update directory " + directory;
                    log.error(errorMessage, (Throwable)e);
                    this.errors.add(errorMessage + ", error is " + e.getMessage());
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Directory " + directory + " will not be upgraded.");
        }
    }

    private void updateDirectory(Directory directory) throws DataAccessException, DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
        directoryToUpdate.setImplementationClass(this.getNewImplementationClass(directory.getImplementationClass()));
        if (directory.getType().equals((Object)DirectoryType.DELEGATING)) {
            String delegatedDirectoryType = directory.getValue("crowd.delegated.directory.type");
            directoryToUpdate.setAttribute("crowd.delegated.directory.type", this.getNewImplementationClass(delegatedDirectoryType));
        }
        this.directoryDao.update((Directory)directoryToUpdate);
    }

    private String getNewImplementationClass(String implementationClass) {
        return this.directoryImplementations.get(implementationClass);
    }

    private boolean isUpgradableDirectory(Directory directory) {
        return this.directoryImplementations.containsKey(directory.getImplementationClass());
    }

    private List<Directory> getAllDirectories() {
        return this.directoryDao.search(this.getAllDirectoriesQuery());
    }

    private EntityQuery<Directory> getAllDirectoriesQuery() {
        return QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

