/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin;

import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.plugin.PluginDirectoryLocator;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.loaders.SinglePluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdPluginManager
extends DefaultPluginManager
implements PluginController,
PluginAccessor {
    private static final Logger log = LoggerFactory.getLogger(CrowdPluginManager.class);
    private boolean initialised = false;

    public CrowdPluginManager(PluginPersistentStateStore pluginStateStore, List pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, PluginDirectoryLocator pluginDirectoryLocator, EventPublisher eventPublisher) {
        super(pluginStateStore, CrowdPluginManager.replaceStringsWithPluginLoaders(pluginLoaders), moduleDescriptorFactory, pluginEventManager);
        FilePluginInstaller installer = new FilePluginInstaller(pluginDirectoryLocator.getPluginsDirectory());
        this.setPluginInstaller((PluginInstaller)installer);
        eventPublisher.register((Object)this);
    }

    private static List replaceStringsWithPluginLoaders(List list) {
        ListIterator<SinglePluginLoader> it = list.listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof String)) continue;
            it.remove();
            it.add(new SinglePluginLoader((String)o));
        }
        return list;
    }

    public void init() throws PluginParseException {
        if (this.initialised) {
            log.error("Init() called on an already initialised plugin manager. Ignoring.");
            return;
        }
        super.init();
        this.initialised = true;
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent event) {
        try {
            this.init();
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Error initialising plugin manager: " + e.getMessage(), e);
        }
    }
}

