/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.migration.GenericMapper;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class XmlMapper
extends GenericMapper {
    public static final String GENERIC_XML_ID = "id";
    public static final String GENERIC_XML_NAME = "name";
    public static final String GENERIC_XML_CREATED_DATE = "createdDate";
    public static final String GENERIC_XML_UPDATED_DATE = "updatedDate";
    public static final String GENERIC_XML_ACTIVE = "active";
    public static final String GENERIC_XML_ATTRIBUTES = "attributes";
    public static final String GENERIC_XML_ATTRIBUTE = "attribute";
    public static final String GENERIC_XML_ATTRIBUTE_NAME = "name";
    public static final String GENERIC_XML_ATTRIBUTE_VALUE = "value";
    public static final String LEGACY_GENERIC_XML_CONCEPTION = "conception";
    public static final String LEGACY_GENERIC_XML_LASTMODIFIED = "lastModified";
    public static final String LEGACY_GENERIC_XML_ATTRIBUTE_ID = "attributeId";
    public static final String LEGACY_GENERIC_XML_ATTRIBUTE_VALUES = "attributeValues";
    public static final String LEGACY_GENERIC_XML_ATTRIBUTE_VALUE = "attributeValue";
    public static final String LEGACY_GENERIC_XML_ATTRIBUTE_KEY = "attributeKey";
    private DirectoryManager directoryManager;
    protected static final Set<DirectoryType> FULL_BACKUP_DIRECTORY_TYPES = EnumSet.of(DirectoryType.INTERNAL, DirectoryType.DELEGATING);

    public XmlMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor) {
        super(sessionFactory, batchProcessor);
    }

    protected void exportInternalEntity(InternalEntity entity, Element element) {
        element.addElement(GENERIC_XML_ID).addText(entity.getId().toString());
        element.addElement("name").addText(entity.getName());
        element.addElement(GENERIC_XML_CREATED_DATE).addText(this.getDateAsFormattedString(entity.getCreatedDate()));
        element.addElement(GENERIC_XML_UPDATED_DATE).addText(this.getDateAsFormattedString(entity.getUpdatedDate()));
        element.addElement(GENERIC_XML_ACTIVE).addText(Boolean.toString(entity.isActive()));
    }

    protected void exportSingleValuedAttributes(Attributes entity, Element element) {
        Element attributesElement = element.addElement(GENERIC_XML_ATTRIBUTES);
        TreeSet attributeNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        attributeNames.addAll(entity.getKeys());
        for (String name : attributeNames) {
            String value = entity.getValue(name);
            if (name == null || value == null) continue;
            Element attributeElement = attributesElement.addElement(GENERIC_XML_ATTRIBUTE);
            attributeElement.addElement("name").addText(name);
            attributeElement.addElement(GENERIC_XML_ATTRIBUTE_VALUE).addText(value);
        }
    }

    protected InternalEntityTemplate getInternalEntityTemplateFromXml(Element element) {
        InternalEntityTemplate template = new InternalEntityTemplate();
        template.setId(Long.valueOf(Long.parseLong(element.element(GENERIC_XML_ID).getText())));
        template.setName(element.element("name").getText());
        template.setCreatedDate(this.getDateFromXml(element.element(GENERIC_XML_CREATED_DATE).getText()));
        template.setUpdatedDate(this.getDateFromXml(element.element(GENERIC_XML_UPDATED_DATE).getText()));
        template.setActive(Boolean.parseBoolean(element.element(GENERIC_XML_ACTIVE).getText()));
        return template;
    }

    protected Map<String, String> getSingleValuedAttributesMapFromXml(Element element) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        Element attributesElement = element.element(GENERIC_XML_ATTRIBUTES);
        Iterator attributes = attributesElement.elementIterator();
        while (attributes.hasNext()) {
            Element attributeElement = (Element)attributes.next();
            attributesMap.put(attributeElement.element("name").getText(), attributeElement.element(GENERIC_XML_ATTRIBUTE_VALUE).getText());
        }
        return attributesMap;
    }

    protected List<Directory> findAllExportableDirectories() {
        ArrayList<PropertyRestriction> restrictions = new ArrayList<PropertyRestriction>(FULL_BACKUP_DIRECTORY_TYPES.size());
        for (DirectoryType type : FULL_BACKUP_DIRECTORY_TYPES) {
            restrictions.add(Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)type));
        }
        return this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.anyOf(restrictions)).returningAtMost(-1));
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

