/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.token.factory;

import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.token.factory.TokenFactory;
import com.atlassian.crowd.manager.token.factory.TokenKeyGenerator;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TokenFactoryImpl
implements TokenFactory {
    private final TokenKeyGenerator tokenKeyGenerator;
    private final SecureRandomService secureRandomService;

    public TokenFactoryImpl(TokenKeyGenerator tokenKeyGenerator, SecureRandomService secureRandomService) {
        this.tokenKeyGenerator = tokenKeyGenerator;
        this.secureRandomService = secureRandomService;
    }

    public TokenFactoryImpl(TokenKeyGenerator tokenKeyGenerator) {
        this(tokenKeyGenerator, DefaultSecureRandomService.getInstance());
    }

    @Override
    public Token create(long directoryID, String name, List<ValidationFactor> validationFactors) throws InvalidTokenException {
        return this.create(directoryID, name, validationFactors, this.createSecretValidationNumber());
    }

    @Override
    public Token create(long directoryID, String name, List<ValidationFactor> validationFactors, long secretNumber) throws InvalidTokenException {
        String identifierHash = this.tokenKeyGenerator.generateKey(directoryID, name, validationFactors);
        ImmutableList withRandomNumber = ImmutableList.builder().addAll(validationFactors).add((Object)new ValidationFactor("Random-Number", Long.toString(secretNumber))).build();
        String randomHash = this.tokenKeyGenerator.generateKey(directoryID, name, (List<ValidationFactor>)withRandomNumber);
        return new Token(directoryID, name, identifierHash, secretNumber, randomHash);
    }

    protected long createSecretValidationNumber() {
        long randomLong = this.secureRandomService.nextLong();
        if (randomLong < 0L) {
            if (randomLong == Long.MIN_VALUE) {
                return 0L;
            }
            return -randomLong;
        }
        return randomLong;
    }
}

