/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.license;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.extras.core.LicenseManagerFactory;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicensePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdLicenseStore {
    private static final Logger log = LoggerFactory.getLogger(CrowdLicenseStore.class);
    private final LicenseStore licenseStore = new LicenseStore();

    public CrowdLicense getLicense() {
        return this.licenseStore.getLicense();
    }

    public CrowdLicense storeLicense(String license) {
        return this.licenseStore.setLicense(license);
    }

    public static AtlassianLicense getAtlassianLicense(String license) {
        if (license != null) {
            return LicenseManagerFactory.getLicenseManager().getLicense(license);
        }
        return null;
    }

    public static CrowdLicense getCrowdLicense(AtlassianLicense atlassianLicense) {
        if (atlassianLicense != null) {
            return (CrowdLicense)atlassianLicense.getProductLicense(Product.CROWD);
        }
        return null;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.licenseStore.setBootstrapManager(bootstrapManager);
    }

    static final class LicenseStore {
        private static final String LICENSE = "license";
        private static final String LICENSE_HASH = "license.hash";
        private static final String LICENSE_MESSAGE = "license.message";
        private AtlassianBootstrapManager bootstrapManager;
        private CrowdLicense license;

        LicenseStore() {
        }

        CrowdLicense setLicense(String licenseText) {
            this.getBootstrapManager().setProperty(LICENSE, (Object)licenseText);
            try {
                this.getBootstrapManager().save();
                this.license = null;
            }
            catch (ConfigurationException e) {
                log.error("Failed to set license", (Throwable)e);
            }
            return this.getLicense();
        }

        CrowdLicense getLicense() {
            if (this.license == null) {
                String licenseText = (String)this.getBootstrapManager().getProperty(LICENSE);
                if (licenseText == null) {
                    String licenceMessage = (String)this.getBootstrapManager().getProperty(LICENSE_MESSAGE);
                    String licenseHash = (String)this.getBootstrapManager().getProperty(LICENSE_HASH);
                    try {
                        licenseText = new LicensePair(licenceMessage, licenseHash).getOriginalLicenseString();
                    }
                    catch (LicenseException e) {
                        log.warn("Could NOT create license pair from license message <" + licenceMessage + "> and license hash <" + licenseHash + ">");
                    }
                }
                this.license = CrowdLicenseStore.getCrowdLicense(CrowdLicenseStore.getAtlassianLicense(licenseText));
            }
            return this.license;
        }

        private AtlassianBootstrapManager getBootstrapManager() {
            if (this.bootstrapManager == null) {
                this.bootstrapManager = BootstrapUtils.getBootstrapManager();
            }
            return this.bootstrapManager;
        }

        void setBootstrapManager(AtlassianBootstrapManager bootstrapManager) {
            this.bootstrapManager = bootstrapManager;
        }
    }
}

