/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.license;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.license.LicenseRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdLicenseRegistry
implements LicenseRegistry {
    private static final Logger log = LoggerFactory.getLogger(CrowdLicenseRegistry.class);
    private CrowdBootstrapManager bootstrapManager = null;
    public static final String LICENSE_HASH = "license.hash";
    public static final String LICENSE_MESSAGE = "license.message";

    public void setLicenseHash(String string) {
        this.getBootstrapManager().setProperty(LICENSE_HASH, string);
        try {
            this.getBootstrapManager().save();
        }
        catch (ConfigurationException e) {
            log.error("Failed to set licenseHash", (Throwable)e);
        }
    }

    public void setLicenseMessage(String string) {
        this.getBootstrapManager().setProperty(LICENSE_MESSAGE, string);
        try {
            this.getBootstrapManager().save();
        }
        catch (ConfigurationException e) {
            log.error("Failed to set licenseMessage", (Throwable)e);
        }
    }

    public String getLicenseMessage() {
        return (String)this.getBootstrapManager().getProperty(LICENSE_MESSAGE);
    }

    public String getLicenseHash() {
        return (String)this.getBootstrapManager().getProperty(LICENSE_HASH);
    }

    public CrowdBootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (CrowdBootstrapManager)BootstrapUtils.getBootstrapManager();
        }
        return this.bootstrapManager;
    }

    public void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

