/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.bootstrap;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.DefaultAtlassianBootstrapManager;
import com.atlassian.config.lifecycle.events.ApplicationStartedEvent;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.plugin.PluginUtils;
import com.atlassian.crowd.util.persistence.hibernate.MappingResources;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationManager;
import javax.servlet.ServletContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CrowdBootstrapManagerImpl
extends DefaultAtlassianBootstrapManager
implements CrowdBootstrapManager {
    public String getConfigDirectory() {
        return (String)this.getProperty("crowd.config.directory");
    }

    public void setConfigDirectory(String configurationDirectory) {
        this.setProperty("crowd.config.directory", configurationDirectory);
    }

    protected void postBootstrapDatabase() {
        super.postBootstrapDatabase();
        PluginUtils.initialiseWebworkForPluginSupport(ServletActionContext.getServletContext());
        Configuration config = ConfigurationManager.getConfiguration();
        config.reload();
        EventPublisher eventPublisher = (EventPublisher)ContainerManager.getComponent((String)"eventPublisher");
        eventPublisher.publish((Object)new ApplicationStartedEvent((Object)this));
    }

    public static boolean isContainterReady(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext) != null;
    }

    @Override
    public String getServerID() {
        return this.getString("crowd.server.id");
    }

    @Override
    public void setServerID(String sid) throws ConfigurationException {
        this.setProperty("crowd.server.id", sid);
        this.save();
    }

    public void setMappingResources(MappingResources mappingResources) {
        this.setTables(mappingResources.getTableNames());
    }
}

