/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.application.CrowdApplicationPasswordManager;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.crowd.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdApplicationPasswordManagerGeneric
implements CrowdApplicationPasswordManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TokenAuthenticationManager tokenAuthenticationManager;
    private ApplicationManager applicationManager;
    private PasswordHelper passwordHelper;
    private PropertyUtils propertyUtils;
    private ClientProperties clientProperties;
    private I18nHelper i18nHelper;
    private ResourceLocator resourceLocator;

    @Override
    public void resetCrowdPasswordIfRequired() throws ApplicationManagerException, ApplicationNotFoundException {
        try {
            ApplicationAuthenticationContext applicationAuthContext = new ApplicationAuthenticationContext();
            applicationAuthContext.setName(this.clientProperties.getApplicationName());
            applicationAuthContext.setCredential(new PasswordCredential(this.clientProperties.getApplicationPassword()));
            this.tokenAuthenticationManager.authenticateApplication(applicationAuthContext);
        }
        catch (InvalidAuthenticationException e) {
            this.logger.info("Password in crowd.properties does not match imported data. Resetting the Crowd application's password in the database.");
            Application crowdApp = this.applicationManager.findByName(IdentifierUtils.toLowerCase((String)this.i18nHelper.getText("application.name")));
            String password = this.passwordHelper.generateRandomPassword();
            PasswordCredential credential = new PasswordCredential(password);
            this.applicationManager.updateCredential(crowdApp, credential);
            this.propertyUtils.updateProperty(this.resourceLocator.getResourceLocation(), "application.password", password);
            this.logger.info("Password for Crowd app has been reset in the database and crowd.properties");
        }
        this.clientProperties.updateProperties(this.resourceLocator.getProperties());
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setPasswordHelper(PasswordHelper passwordHelper) {
        this.passwordHelper = passwordHelper;
    }

    public void setPropertyUtils(PropertyUtils propertyUtils) {
        this.propertyUtils = propertyUtils;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public void setTokenAuthenticationManager(TokenAuthenticationManager tokenAuthenticationManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public void setClientProperties(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }
}

