/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.mappers.jdbc;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.crowd.util.UserUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;

public class UserMapper
implements RowMapper {
    private final Configuration configuration;
    private final PasswordHelper passwordHelper;
    private final String name;
    private final String email;
    private final String fullname;
    private final String password;

    public UserMapper(Configuration configuration, PasswordHelper passwordHelper, String name, String email, String fullname, String password) {
        this.configuration = configuration;
        this.passwordHelper = passwordHelper;
        this.name = name;
        this.email = email;
        this.fullname = fullname;
        this.password = password;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        String username = rs.getString(this.name);
        PasswordCredential credential = null;
        credential = this.configuration.isImportPasswords() != false ? new PasswordCredential(rs.getString(this.password), true) : new PasswordCredential(this.passwordHelper.generateRandomPassword(), false);
        UserTemplate user = new UserTemplate(username, this.configuration.getDirectoryID().longValue());
        user.setActive(true);
        user.setEmailAddress(rs.getString(this.email));
        user.setDisplayName(rs.getString(this.fullname));
        User populatedUser = UserUtils.populateNames((User)user);
        return new UserTemplateWithCredentialAndAttributes(populatedUser, credential);
    }
}

