/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.mappers.csv;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.importer.mappers.csv.CsvMapper;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.PasswordHelper;
import org.apache.commons.collections.OrderedBidiMap;
import org.apache.commons.lang.StringUtils;

public class UserMapper
extends CsvMapper<UserTemplateWithCredentialAndAttributes> {
    private PasswordHelper passwordHelper;
    private Boolean setpassword;
    private Boolean encryptPassword;

    public UserMapper(Long directoryId, OrderedBidiMap configuration, PasswordHelper passwordHelper, Boolean setPassword, Boolean encryptPassword) {
        super(directoryId, configuration);
        this.passwordHelper = passwordHelper;
        this.setpassword = setPassword;
        this.encryptPassword = encryptPassword;
    }

    @Override
    public UserTemplateWithCredentialAndAttributes mapRow(String[] resultSet) {
        UserTemplateWithCredentialAndAttributes user = null;
        if (resultSet != null && resultSet.length > 0) {
            String username = this.getString(resultSet, "user.username");
            PasswordCredential credential = null;
            String password = this.getString(resultSet, "user.password");
            if (StringUtils.isNotBlank((String)password)) {
                credential = new PasswordCredential(password);
                if (this.encryptPassword.booleanValue()) {
                    credential.setEncryptedCredential(false);
                } else {
                    credential.setEncryptedCredential(true);
                }
            } else {
                credential = new PasswordCredential(this.passwordHelper.generateRandomPassword(), false);
            }
            user = new UserTemplateWithCredentialAndAttributes(username, this.directoryId.longValue(), credential);
            user.setActive(true);
            user.setEmailAddress(this.getString(resultSet, "user.emailaddress"));
            user.setFirstName(this.getString(resultSet, "user.firstname"));
            user.setLastName(this.getString(resultSet, "user.lastname"));
        }
        return user;
    }
}

