/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.console.embedded.api;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.service.client.ClientProperties;

public class CrowdApplicationFactory
implements ApplicationFactory {
    private final ApplicationDAO applicationDao;
    private ClientProperties clientProperties;

    public CrowdApplicationFactory(ApplicationDAO applicationDao, ClientProperties clientProperties) {
        this.applicationDao = applicationDao;
        this.clientProperties = clientProperties;
    }

    public Application getApplication() {
        String applicationName = this.clientProperties.getApplicationName();
        try {
            return this.applicationDao.findByName(applicationName);
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException("Crowd application with name <" + applicationName + "> was not found in the database", e);
        }
    }
}

