/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import com.atlassian.crowd.upgrade.util.UpgradeUtilityDAOHibernate;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class UpgradeTask523
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask523.class);
    private UpgradeUtilityDAOHibernate upgradeUtilityDao;

    @Override
    public String getBuildNumber() {
        return "523";
    }

    @Override
    public String getShortDescription() {
        return "Designate pre-existing groups in delegated authentication directories as being local";
    }

    @Override
    public void doUpgrade() throws Exception {
        HibernateTemplate hibernateTemplate = this.upgradeUtilityDao.getHibernateTemplate();
        log.info("{} groups updated", (Object)hibernateTemplate.bulkUpdate("update InternalGroup g set local = true where g.directory in (select d from DirectoryImpl d where type = ?)", (Object)DirectoryType.DELEGATING));
        hibernateTemplate.flush();
    }

    @Override
    public Collection<String> getErrors() {
        return Collections.emptySet();
    }

    public void setUpgradeUtilityDao(UpgradeUtilityDAOHibernate upgradeUtilityDao) {
        this.upgradeUtilityDao = upgradeUtilityDao;
    }
}

