/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.web;

import com.atlassian.crowd.plugin.web.TemplateRenderer;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.LocaleProvider;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.springframework.web.context.ServletContextAware;

public class CrowdTemplateRenderer
implements TemplateRenderer,
ServletContextAware {
    private FreemarkerManager freemarkerManager;
    private ServletContext servletContext;
    private static final Logger log = Logger.getLogger(CrowdTemplateRenderer.class);

    @Override
    public String render(String templatePath, Map contextParams) {
        try {
            ActionContext ctx = ServletActionContext.getContext();
            HttpServletRequest req = ServletActionContext.getRequest();
            HttpServletResponse res = ServletActionContext.getResponse();
            Configuration config = this.freemarkerManager.getConfiguration(this.servletContext);
            ActionInvocation invocation = ctx.getActionInvocation();
            Locale locale = invocation.getAction() instanceof LocaleProvider ? ((LocaleProvider)invocation.getAction()).getLocale() : config.getLocale();
            Template template = config.getTemplate(templatePath, locale);
            SimpleHash model = this.freemarkerManager.buildTemplateModel(ctx.getValueStack(), null, this.servletContext, req, res, config.getObjectWrapper());
            if (contextParams != null) {
                model.putAll(contextParams);
            }
            StringWriter writer = new StringWriter();
            template.process((Object)model, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error revolving template", (Throwable)e);
            return ExceptionUtils.getFullStackTrace((Throwable)e);
        }
    }

    @Override
    public String renderText(String text, Map params) {
        try {
            ActionContext ctx = ServletActionContext.getContext();
            HttpServletRequest req = ServletActionContext.getRequest();
            HttpServletResponse res = ServletActionContext.getResponse();
            Configuration config = this.freemarkerManager.getConfiguration(this.servletContext);
            config.setNumberFormat("0.######");
            Template template = new Template("URLTemplate", (Reader)new StringReader(text), config);
            SimpleHash model = this.freemarkerManager.buildTemplateModel(ctx.getValueStack(), null, this.servletContext, req, res, config.getObjectWrapper());
            if (params != null) {
                model.putAll(params);
            }
            StringWriter writer = new StringWriter();
            template.process((Object)model, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error revolving template", (Throwable)e);
            return ExceptionUtils.getFullStackTrace((Throwable)e);
        }
    }

    public void setFreemarkerManager(FreemarkerManager freemarkerManager) {
        this.freemarkerManager = freemarkerManager;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

