/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.application.springsecurity;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.CrowdAuthenticationProvider;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdDataAccessException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.service.soap.ObjectTranslator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class LocalCrowdAuthenticationProvider
extends CrowdAuthenticationProvider {
    private static final String ROLE_PREFIX = "ROLE_";
    private final ApplicationManager applicationManager;
    private final ApplicationService applicationService;
    private final TokenAuthenticationManager tokenAuthenticationManager;

    public LocalCrowdAuthenticationProvider(Application application, ApplicationService applicationService, ApplicationManager applicationManager, TokenAuthenticationManager tokenAuthenticationManager) {
        super(application.getName());
        this.applicationService = applicationService;
        this.applicationManager = applicationManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    protected boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, RemoteException {
        try {
            this.tokenAuthenticationManager.validateUserToken(token, validationFactors, this.applicationName);
            return true;
        }
        catch (InvalidTokenException e) {
            return false;
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
        catch (OperationFailedException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    protected String authenticate(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, RemoteException, ExpiredCredentialException {
        UserAuthenticationContext pac = new UserAuthenticationContext();
        pac.setName(username);
        pac.setCredential(new PasswordCredential(password));
        pac.setApplication(this.applicationName);
        pac.setValidationFactors(validationFactors);
        try {
            Token token = this.tokenAuthenticationManager.authenticateUser(pac);
            return token.getRandomHash();
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new ApplicationAccessDeniedException((Throwable)e);
        }
        catch (OperationFailedException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ApplicationNotFoundException e) {
            throw new InvalidAuthorizationTokenException((Throwable)e);
        }
    }

    protected CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            Application application = this.getApplication();
            SOAPPrincipal principal = ObjectTranslator.processUser(this.applicationService.findUserByName(application, username));
            return new CrowdUserDetails(principal, this.findGrantedAuthorities(principal.getName()));
        }
        catch (UserNotFoundException e) {
            throw new UsernameNotFoundException("User " + username + " not found under application: " + this.applicationName, (Throwable)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
    }

    protected CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        try {
            SOAPPrincipal principal = ObjectTranslator.processUser(this.tokenAuthenticationManager.findUserByToken(token, this.getApplication().getName()));
            return new CrowdUserDetails(principal, this.findGrantedAuthorities(principal.getName()));
        }
        catch (OperationFailedException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (InvalidTokenException e) {
            throw new CrowdSSOTokenInvalidException("Invalid token: " + token, (Throwable)e);
        }
        catch (ApplicationNotFoundException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (com.atlassian.crowd.manager.application.ApplicationAccessDeniedException e) {
            throw new CrowdSSOTokenInvalidException("Invalid token: " + token, (Throwable)e);
        }
    }

    private GrantedAuthority[] findGrantedAuthorities(String username) throws ApplicationNotFoundException {
        ArrayList<GrantedAuthorityImpl> auths = new ArrayList<GrantedAuthorityImpl>();
        List groups = this.applicationService.searchNestedGroupRelationships(this.getApplication(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(username).returningAtMost(-1));
        for (String group : groups) {
            auths.add(new GrantedAuthorityImpl(ROLE_PREFIX + group));
        }
        return auths.toArray(new GrantedAuthority[auths.size()]);
    }

    private Application getApplication() throws ApplicationNotFoundException {
        return this.applicationManager.findByName(this.applicationName);
    }
}

