/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.verify;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.migration.verify.DatabaseVerifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;

public class LegacyDatabaseVerifier
extends DatabaseVerifier {
    private static final Logger logger = Logger.getLogger(LegacyDatabaseVerifier.class);
    private final Map<Long, Set<String>> directoryToRoleNames = new HashMap<Long, Set<String>>();
    private final Map<Long, Set<String>> directoryToGroupNames = new HashMap<Long, Set<String>>();
    private final JdbcOperations jdbcTemplate;

    public LegacyDatabaseVerifier(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public void verify() {
        logger.info((Object)"Checking legacy database for data validity.");
        try {
            GroupTableVerifier groupTableVerifier = new GroupTableVerifier();
            this.jdbcTemplate.query(this.legacyTableQueries.getVerifyGroupsSQL(), (RowCallbackHandler)groupTableVerifier);
            RoleTableVerifier roleTableVerifier = new RoleTableVerifier();
            this.jdbcTemplate.query(this.legacyTableQueries.getVerifyRolesSQL(), (RowCallbackHandler)roleTableVerifier);
        }
        catch (DataAccessException e) {
            this.errors.add("An error occurred when querying the database <" + e.getMostSpecificCause().getMessage() + ">");
        }
    }

    @Override
    public void clearState() {
        this.getErrors().clear();
        this.directoryToRoleNames.clear();
        this.directoryToGroupNames.clear();
    }

    private class RoleTableVerifier
    implements RowCallbackHandler {
        private RoleTableVerifier() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long directoryId = rs.getLong("ID");
            String roleName = rs.getString("NAME");
            String standardRoleName = IdentifierUtils.toLowerCase((String)roleName);
            HashSet<String> roleNames = (HashSet<String>)LegacyDatabaseVerifier.this.directoryToRoleNames.get(directoryId);
            Set groupNames = (Set)LegacyDatabaseVerifier.this.directoryToGroupNames.get(directoryId);
            if (roleNames == null) {
                roleNames = new HashSet<String>();
                LegacyDatabaseVerifier.this.directoryToRoleNames.put(directoryId, roleNames);
            }
            if (roleNames.contains(standardRoleName)) {
                LegacyDatabaseVerifier.this.errors.add("Could not add role with name '" + roleName + "' as it matches another role name in the same directory with id: " + directoryId);
            } else if (groupNames != null && groupNames.contains(standardRoleName)) {
                LegacyDatabaseVerifier.this.errors.add("Could not add role with name '" + roleName + "' as it matches another group name in the same directory with id: " + directoryId);
            } else {
                roleNames.add(standardRoleName);
            }
        }
    }

    private class GroupTableVerifier
    implements RowCallbackHandler {
        private GroupTableVerifier() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Long directoryId = rs.getLong("ID");
            String groupName = rs.getString("NAME");
            String standardGroupName = IdentifierUtils.toLowerCase((String)groupName);
            Set roleNames = (Set)LegacyDatabaseVerifier.this.directoryToRoleNames.get(directoryId);
            HashSet<String> groupNames = (HashSet<String>)LegacyDatabaseVerifier.this.directoryToGroupNames.get(directoryId);
            if (groupNames == null) {
                groupNames = new HashSet<String>();
                LegacyDatabaseVerifier.this.directoryToGroupNames.put(directoryId, groupNames);
            }
            if (groupNames.contains(standardGroupName)) {
                LegacyDatabaseVerifier.this.errors.add("Could not add group with name '" + groupName + "' as it matches another group name in the same directory with id: " + directoryId);
            } else if (roleNames != null && roleNames.contains(standardGroupName)) {
                LegacyDatabaseVerifier.this.errors.add("Could not add group with name '" + groupName + "' as it matches another role name in the same directory with id: " + directoryId);
            } else {
                groupNames.add(standardGroupName);
            }
        }
    }
}

